/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import wardentools.advancement.ModCriteriaTriggers;
import wardentools.block.BlockRegistry;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ContagionIncarnationCorpseEntity;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.entity.custom.CrystalGolemEntity;
import wardentools.entity.custom.DeepLurkerEntity;
import wardentools.entity.custom.NoctilureEntity;
import wardentools.entity.custom.PaleWandererEntity;
import wardentools.entity.custom.ParasyteEntity;
import wardentools.entity.custom.ProtectorEntity;
import wardentools.entity.custom.ShadowEntity;
import wardentools.entity.custom.TemperEntity;
import wardentools.particle.ParticleRegistry;
import wardentools.particle.custom.AbyssAmbient;
import wardentools.particle.custom.AbyssPortal;
import wardentools.particle.custom.BlackCorruption;
import wardentools.particle.custom.Corruption;
import wardentools.particle.custom.GlyphParticle;
import wardentools.particle.custom.GlyphParticleRotating;
import wardentools.particle.custom.Radiance;
import wardentools.particle.custom.ShineParticle;

@EventBusSubscriber(modid="wardentools")
public class CommonModEvents {
    @SubscribeEvent
    public static void registerEvent(RegisterEvent event) {
        ModCriteriaTriggers.init();
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(BlockRegistry.WHITE_TORCHFLOWER.getId(), BlockRegistry.POTTED_WHITE_TORCHFLOWER));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(ModEntities.DEEPLURKER.get(), DeepLurkerEntity.createAttribute().build());
        event.put(ModEntities.PALE_WANDERER.get(), PaleWandererEntity.createAttribute().build());
        event.put(ModEntities.PROTECTOR.get(), ProtectorEntity.createAttribute().build());
        event.put(ModEntities.CONTAGION_INCARNATION.get(), ContagionIncarnationEntity.createAttribute().build());
        event.put(ModEntities.TEMPER.get(), TemperEntity.createAttribute().build());
        event.put(ModEntities.PARASYTE.get(), ParasyteEntity.createAttribute().build());
        event.put(ModEntities.NOCTILURE.get(), NoctilureEntity.createAttribute().build());
        event.put(ModEntities.SHADOW.get(), ShadowEntity.createAttribute().build());
        event.put(ModEntities.CONTAGION_INCARNATION_CORPSE.get(), ContagionIncarnationCorpseEntity.createAttribute().build());
        event.put(ModEntities.CRYSTAL_GOLEM.get(), CrystalGolemEntity.createAttribute().build());
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register(ModEntities.DEEPLURKER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, DeepLurkerEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.PALE_WANDERER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, PaleWandererEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.PROTECTOR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ProtectorEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.CONTAGION_INCARNATION.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ContagionIncarnationEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.TEMPER.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING, TemperEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.PARASYTE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ParasyteEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.NOCTILURE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.WORLD_SURFACE, NoctilureEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.SHADOW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ShadowEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register(ModEntities.CRYSTAL_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, CrystalGolemEntity::canSpawn, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.ABYSS_AMBIENT.get(), AbyssAmbient.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.CORRUPTION.get(), Corruption.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.ABYSS_PORTAL.get(), AbyssPortal.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.RADIANCE.get(), Radiance.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.BLACK_CORRUPTION.get(), BlackCorruption.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.SHINE_PARTICLE.get(), ShineParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.GLYPH_PARTICLE.get(), GlyphParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.GLYPH_PARTICLE_ROTATING.get(), GlyphParticleRotating.Provider::new);
    }
}

