/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.VanillaGameEvent;
import wardentools.items.enchantment.EnchantmentRegistry;

@EventBusSubscriber(modid="wardentools")
public class GameEventVibrationInterceptor {
    @SubscribeEvent
    public static void onGameEvent(VanillaGameEvent event) {
        Entity entity = event.getCause();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
            ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
            ItemStack leggings = player.getItemBySlot(EquipmentSlot.LEGS);
            ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
            if (GameEventVibrationInterceptor.isStealthEnchanted(player, boots) && GameEventVibrationInterceptor.isStealthEnchanted(player, helmet) && GameEventVibrationInterceptor.isStealthEnchanted(player, leggings) && GameEventVibrationInterceptor.isStealthEnchanted(player, chestplate)) {
                event.setCanceled(true);
                return;
            }
            if (event.getVanillaEvent() == GameEvent.HIT_GROUND) {
                if (GameEventVibrationInterceptor.isStealthEnchanted(player, leggings)) {
                    event.setCanceled(true);
                }
            } else if (event.getVanillaEvent() == GameEvent.BLOCK_PLACE || event.getVanillaEvent() == GameEvent.BLOCK_DESTROY || event.getVanillaEvent() == GameEvent.BLOCK_CHANGE) {
                if (GameEventVibrationInterceptor.isStealthEnchanted(player, chestplate)) {
                    event.setCanceled(true);
                }
            } else if (event.getVanillaEvent() == GameEvent.STEP && GameEventVibrationInterceptor.isStealthEnchanted(player, boots)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean isStealthEnchanted(Player player, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        RegistryAccess registryAccess = player.registryAccess();
        Registry enchantmentRegistry = registryAccess.registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference stealthEnchantment = enchantmentRegistry.getHolderOrThrow(EnchantmentRegistry.STEALTH);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)stealthEnchantment, (ItemStack)stack) > 0;
    }
}

