/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.blockentity.CrystalInfuserBlockEntity;
import wardentools.items.ItemRegistry;
import wardentools.misc.Crystal;
import wardentools.network.payloads.special_effects.ParticleShineExplosion;
import wardentools.particle.ModParticleUtils;
import wardentools.particle.options.GlyphParticleRotatingOptions;
import wardentools.particle.options.ShineParticleOptions;

public class CrystalInfuserBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final MapCodec<CrystalInfuserBlock> CODEC = CrystalInfuserBlock.simpleCodec(CrystalInfuserBlock::new);
    public static final EnumProperty<Crystal> CRYSTAL;
    private static final Vec3[] positions;
    private static final float shineSpeed = 0.04f;
    private static final float explosionSpeed = 0.1f;

    public CrystalInfuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(CRYSTAL, (Comparable)((Object)Crystal.getDefault()))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<CrystalInfuserBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystalInfuserBlockEntity) {
            CrystalInfuserBlockEntity infuser = (CrystalInfuserBlockEntity)blockEntity;
            if (stack.isEmpty()) {
                ItemStack removedItem = infuser.removeItemInOrder();
                if (!removedItem.isEmpty()) {
                    for (int i = 0; i < player.getInventory().items.size(); ++i) {
                        if (removedItem.is((Item)ItemRegistry.CRYSTAL_RESONATOR.get()) || !((ItemStack)player.getInventory().items.get(i)).is(removedItem.getItem())) continue;
                        ((ItemStack)player.getInventory().items.get(i)).grow(1);
                        return ItemInteractionResult.SUCCESS;
                    }
                    player.setItemInHand(hand, removedItem);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (infuser.setItemInAvailableSlot(stack)) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CRYSTAL, FACING});
        super.createBlockStateDefinition(builder);
    }

    public static Crystal getCrystal(BlockState state) {
        return (Crystal)((Object)state.getValue(CRYSTAL));
    }

    public static int getCrystalColor(BlockState state) {
        return CrystalInfuserBlock.getCrystal(state).getColor();
    }

    public static int getColor(@NotNull BlockState blockState, @Nullable BlockAndTintGetter blockAndTintGetter, @Nullable BlockPos blockPos, int index) {
        if (index != 0) {
            return -1;
        }
        return CrystalInfuserBlock.getCrystalColor(blockState);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new CrystalInfuserBlockEntity(blockPos, blockState);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide() && (be = level.getBlockEntity(pos)) instanceof CrystalInfuserBlockEntity) {
            CrystalInfuserBlockEntity blockEntity = (CrystalInfuserBlockEntity)be;
            ItemStackHandler inventory = blockEntity.getInventory();
            for (int index = 0; index < inventory.getSlots(); ++index) {
                ItemStack stackDrop = inventory.getStackInSlot(index);
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stackDrop);
                level.addFreshEntity((Entity)entity);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrystalInfuserBlockEntity) {
            CrystalInfuserBlockEntity infuser = (CrystalInfuserBlockEntity)blockEntity;
            if (infuser.isInfusing()) {
                infuser.completeInfuse();
            } else {
                CrystalInfuserBlock.particleExplosion(state, pos, (Level)level);
            }
        }
        super.tick(state, level, pos, random);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
    }

    public static void giantCompassParticle(BlockState state, Level level, CrystalInfuserBlockEntity infuser) {
        if (!state.hasProperty((Property)FACING)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Vec3 center = infuser.getStainedGlassCenterPos().getCenter();
        float orientation = infuser.getNextTempleOrientation();
        Vec3 rightX = switch (facing) {
            case Direction.NORTH -> new Vec3(1.0, 0.0, 0.0);
            case Direction.SOUTH -> new Vec3(-1.0, 0.0, 0.0);
            case Direction.EAST -> new Vec3(0.0, 0.0, -1.0);
            default -> new Vec3(0.0, 0.0, 1.0);
        };
        Vec3 upY = new Vec3(0.0, 1.0, 0.0);
        switch (facing) {
            case NORTH: {
                orientation = -orientation;
                break;
            }
            case EAST: {
                orientation += 1.5707964f;
                break;
            }
            case WEST: {
                orientation -= 1.5707964f;
                break;
            }
            case SOUTH: {
                orientation = -orientation + (float)Math.PI;
                break;
            }
        }
        Vec3 dir = rightX.scale(Math.cos(orientation)).add(upY.scale(Math.sin(orientation)));
        for (int i = 0; i < 25; ++i) {
            Vec3 from = center.offsetRandom(level.random, 1.5f);
            from = from.add(dir.scale((double)(level.random.nextFloat() * 6.0f)));
            ModParticleUtils.addClientParticle(level, new ShineParticleOptions(Vec3.ZERO, CrystalInfuserBlock.getCrystalColor(state)), from, dir.scale((double)0.2f));
        }
    }

    public static void ambientParticles(BlockState state, BlockPos pos, Level level) {
        if (!state.hasProperty((Property)FACING)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos minPos = pos.relative(facing.getOpposite(), 9).relative(facing.getClockWise(), 10).below(3);
        BlockPos maxPos = pos.relative(facing, 3).relative(facing.getClockWise(), -10).above(8);
        for (int i = 0; i < 22; ++i) {
            Vec3 partPos = new Vec3((double)(level.random.nextFloat() * (float)(maxPos.getX() - minPos.getX()) + (float)minPos.getX()), (double)(level.random.nextFloat() * (float)(maxPos.getY() - minPos.getY()) + (float)minPos.getY()), (double)(level.random.nextFloat() * (float)(maxPos.getZ() - minPos.getZ()) + (float)minPos.getZ()));
            ModParticleUtils.addStaticClientParticle(level, new ShineParticleOptions(Vec3.ZERO, CrystalInfuserBlock.getCrystalColor(state)), partPos);
        }
    }

    public static void particleGlyph(BlockState state, BlockPos pos, Level level) {
        if (!state.hasProperty((Property)FACING)) {
            return;
        }
        double baseX = pos.getX();
        double baseY = pos.getY();
        double baseZ = pos.getZ();
        Vec3 center = positions[4].scale(0.0625).add(baseX, baseY, baseZ);
        Vec3 axis = state.getValue((Property)FACING) == Direction.NORTH || state.getValue((Property)FACING) == Direction.SOUTH ? new Vec3(0.0, 0.0, 1.0) : new Vec3(1.0, 0.0, 0.0);
        ModParticleUtils.particleCircle(level, new GlyphParticleRotatingOptions(center, axis, 0.015f, CrystalInfuserBlock.getCrystalColor(state)), center, 1.0f, 10, axis);
        ModParticleUtils.particleCircle(level, new GlyphParticleRotatingOptions(center, axis, -0.017f, CrystalInfuserBlock.getCrystalColor(state)), center, 1.4f, 12, axis);
        ModParticleUtils.particleCircle(level, new GlyphParticleRotatingOptions(center, axis, 0.019f, CrystalInfuserBlock.getCrystalColor(state)), center, 1.8f, 14, axis);
    }

    public static void particleShine(BlockState state, BlockPos pos, Level level, RandomSource random) {
        double baseX = pos.getX();
        double baseY = pos.getY();
        double baseZ = pos.getZ();
        Vec3 center = positions[4].scale(0.0625).add(baseX, baseY, baseZ);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < random.nextInt(1, 2); ++j) {
                Vec3 from = positions[i].scale(0.0625).add(baseX, baseY, baseZ);
                Vec3 dir = center.subtract(from).normalize().scale((double)0.04f + (random.nextDouble() - 0.5) * (double)0.04f / 2.0);
                level.addParticle((ParticleOptions)new ShineParticleOptions(center, CrystalInfuserBlock.getCrystalColor(state)), from.x, from.y, from.z, dir.x, dir.y, dir.z);
            }
        }
    }

    public static void particleExplosion(BlockState state, BlockPos pos, Level level) {
        if (!level.isClientSide) {
            double baseX = pos.getX();
            double baseY = pos.getY();
            double baseZ = pos.getZ();
            Vec3 center = positions[4].scale(0.0625).add(baseX, baseY, baseZ);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(pos).getPos(), (CustomPacketPayload)new ParticleShineExplosion(center.toVector3f(), 0.1f, 0.1f, 100, CrystalInfuserBlock.getCrystalColor(state)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return !level.isClientSide() ? (level0, pos0, state0, blockEntity) -> ((CrystalInfuserBlockEntity)blockEntity).tick() : (level0, pos0, state0, blockEntity) -> ((CrystalInfuserBlockEntity)blockEntity).clientTick();
    }

    static {
        positions = new Vec3[]{new Vec3(10.5, (double)10.35f, 10.5), new Vec3(5.5, (double)10.35f, 5.5), new Vec3(10.5, (double)10.35f, 5.5), new Vec3(5.5, (double)10.35f, 10.5), new Vec3(8.0, 17.0, 8.0)};
        CRYSTAL = EnumProperty.create((String)"crystal_index", Crystal.class);
    }
}

