/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.network.payloads.special_effects.WardenLaserParticleSound;
import wardentools.tags.ModTags;

public class SonicBlaster
extends DirectionalBlock {
    public static final MapCodec<SonicBlaster> CODEC = SonicBlaster.simpleCodec(SonicBlaster::new);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final int TRIGGER_DELAY = 4;
    private static final float LASER_LENGTH = 6.0f;
    private static final float LASER_RADIUS = 1.5f;
    private static final float PUSH_STRENGTH = 2.8f;

    @NotNull
    protected MapCodec<SonicBlaster> codec() {
        return CODEC;
    }

    public SonicBlaster(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.FALSE)).setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext placeContext) {
        BlockState blockStatePlacement = super.getStateForPlacement(placeContext);
        if (blockStatePlacement != null) {
            return (BlockState)blockStatePlacement.setValue((Property)FACING, (Comparable)placeContext.getNearestLookingDirection().getOpposite());
        }
        return null;
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state1, boolean b) {
        super.onPlace(state, level, pos, state1, b);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            if (!level.getBlockState(neighborPos).is(ModTags.Blocks.CRISTAL_BLOCK)) continue;
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            break;
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING}).add(new Property[]{TRIGGERED}).add(new Property[]{POWERED});
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.sonicBoom(level, pos, (Direction)state.getValue((Property)FACING));
    }

    protected void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos posNeighbor, boolean b) {
        if (level.getBlockState(posNeighbor).is(ModTags.Blocks.CRISTAL_BLOCK)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.turnOffIfNoCrystalNeighbor(state, level, pos);
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            boolean redstoneSignal;
            boolean bl = redstoneSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            if (redstoneSignal && !((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
                level.scheduleTick(pos, (Block)this, 4);
                level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
            } else if (!redstoneSignal && ((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        super.neighborChanged(state, level, pos, block, posNeighbor, b);
    }

    private void turnOffIfNoCrystalNeighbor(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            if (!level.getBlockState(neighborPos).is(ModTags.Blocks.CRISTAL_BLOCK)) continue;
            return;
        }
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    private void sonicBoom(ServerLevel level, BlockPos pos, Direction facing) {
        Vec3 origin = Vec3.atCenterOf((Vec3i)pos);
        Vec3 direction = Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).normalize();
        Vec3 target = origin.add(direction.scale(6.0));
        AABB aabb = SonicBlaster.sonicHitBox(facing, origin, target);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunkAt(pos).getPos(), (CustomPacketPayload)new WardenLaserParticleSound(origin.toVector3f(), direction.toVector3f(), 6), (CustomPacketPayload[])new CustomPacketPayload[0]);
        for (Entity entity : level.getEntities(null, aabb)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double knockbackResistance = 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            double knockback = (double)2.8f * knockbackResistance;
            if (facing == Direction.DOWN || facing == Direction.UP) {
                knockback *= 0.3;
            }
            livingEntity.push(direction.x * knockback, direction.y * knockback, direction.z * knockback);
            if (!(livingEntity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket(serverPlayer.getId(), serverPlayer.getDeltaMovement()));
        }
    }

    @NotNull
    private static AABB sonicHitBox(Direction facing, Vec3 origin, Vec3 target) {
        return switch (facing) {
            case Direction.UP, Direction.DOWN -> {
                double minY = Math.min(origin.y, target.y);
                double maxY = Math.max(origin.y, target.y);
                yield new AABB(origin.x - 1.5, minY, origin.z - 1.5, origin.x + 1.5, maxY, origin.z + 1.5);
            }
            case Direction.NORTH, Direction.SOUTH -> {
                double minZ = Math.min(origin.z, target.z);
                double maxZ = Math.max(origin.z, target.z);
                yield new AABB(origin.x - 1.5, origin.y - 1.5, minZ, origin.x + 1.5, origin.y + 1.5, maxZ);
            }
            case Direction.EAST, Direction.WEST -> {
                double minX = Math.min(origin.x, target.x);
                double maxX = Math.max(origin.x, target.x);
                yield new AABB(minX, origin.y - 1.5, origin.z - 1.5, maxX, origin.y + 1.5, origin.z + 1.5);
            }
            default -> throw new IllegalStateException("Unexpected facing: " + String.valueOf(facing));
        };
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

