/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.depthvines;

import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.VoxelShape;
import wardentools.items.ItemRegistry;

public interface DepthVines {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemRegistry.DEPTH_BERRIES.get(), 1));
            float prob = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, prob);
            BlockState newState = (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)newState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState state) {
        return state.hasProperty((Property)BERRIES) && (Boolean)state.getValue((Property)BERRIES) != false;
    }

    public static boolean canHangBelow(BlockState state, LevelReader level, BlockPos pos) {
        return state.isCollisionShapeFullBlock((BlockGetter)level, pos);
    }

    public static ToIntFunction<BlockState> emission(int light) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.BERRIES) != false ? light : 0;
    }
}

