/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.depthvines;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.block.depthvines.DepthVines;
import wardentools.items.ItemRegistry;

public class DepthVinesPlantBlock
extends GrowingPlantBodyBlock
implements BonemealableBlock,
DepthVines {
    public static final MapCodec<CaveVinesPlantBlock> CODEC = DepthVinesPlantBlock.simpleCodec(CaveVinesPlantBlock::new);

    @NotNull
    public MapCodec<CaveVinesPlantBlock> codec() {
        return CODEC;
    }

    public DepthVinesPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected GrowingPlantHeadBlock getHeadBlock() {
        return (GrowingPlantHeadBlock)BlockRegistry.DEPTH_VINES.get();
    }

    @NotNull
    protected BlockState updateHeadAfterConvertedFromBody(BlockState state, BlockState myState) {
        return (BlockState)myState.setValue((Property)BERRIES, (Comparable)((Boolean)state.getValue((Property)BERRIES)));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader levelReader, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)ItemRegistry.DEPTH_BERRIES.get());
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        return DepthVines.use((Entity)player, state, level, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BERRIES});
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return level.getBlockState(pos.above()).is((Block)BlockRegistry.DARKTREE_LEAVES.get()) || super.canSurvive(state, level, pos);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader levelReader, @NotNull BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

