/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.sculktendril;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import wardentools.block.sculktendril.TendrilTree;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.SculkTendrilBlockEntity;

public class SculkTendrilBlock
extends DropExperienceBlock
implements EntityBlock {
    private TendrilTree cachedTendrilTree = null;

    public SculkTendrilBlock(IntProvider intProvider, BlockBehaviour.Properties properties) {
        super(intProvider, properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return BlockEntityRegistry.SCULK_TENDRIL_BLOCK_ENTITY.get().create(pos, state);
    }

    public static VoxelShape makeShape(int width, Map<Direction, Boolean> connections) {
        float halfWidth = (float)width / 32.0f;
        VoxelShape shape = Shapes.box((double)(0.5f - halfWidth), (double)(0.5f - halfWidth), (double)(0.5f - halfWidth), (double)(0.5f + halfWidth), (double)(0.5f + halfWidth), (double)(0.5f + halfWidth));
        int branchLength = 8 - width / 2;
        float branchHalfLength = (float)branchLength / 32.0f;
        for (Direction dir : connections.keySet()) {
            if (!connections.get(dir).booleanValue()) continue;
            float cx = 0.5f + (float)dir.getStepX() * (halfWidth + branchHalfLength);
            float cy = 0.5f + (float)dir.getStepY() * (halfWidth + branchHalfLength);
            float cz = 0.5f + (float)dir.getStepZ() * (halfWidth + branchHalfLength);
            float minX = cx - (dir.getAxis() == Direction.Axis.X ? branchHalfLength : halfWidth);
            float maxX = cx + (dir.getAxis() == Direction.Axis.X ? branchHalfLength : halfWidth);
            float minY = cy - (dir.getAxis() == Direction.Axis.Y ? branchHalfLength : halfWidth);
            float maxY = cy + (dir.getAxis() == Direction.Axis.Y ? branchHalfLength : halfWidth);
            float minZ = cz - (dir.getAxis() == Direction.Axis.Z ? branchHalfLength : halfWidth);
            float maxZ = cz + (dir.getAxis() == Direction.Axis.Z ? branchHalfLength : halfWidth);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        }
        return shape;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            int width = tendrilBlockEntity.getWidth();
            return SculkTendrilBlock.makeShape(width, tendrilBlockEntity.getAllConnections());
        }
        return Shapes.block();
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            if (this.cachedTendrilTree != null) {
                if (pos == this.cachedTendrilTree.getOrigin()) {
                    tendrilBlockEntity.setTendrilTreeGraph(this.cachedTendrilTree);
                } else {
                    tendrilBlockEntity.setOrigin(this.cachedTendrilTree.getOrigin());
                }
                this.recursiveWidthUpdate(level, pos);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext placeContext) {
        BlockPos placePos = placeContext.getClickedPos().relative(placeContext.getClickedFace().getOpposite());
        boolean success = this.createCacheOnPlace(placeContext.getClickedPos(), placePos, placeContext.getLevel());
        return success ? super.getStateForPlacement(placeContext) : null;
    }

    private boolean createCacheOnPlace(BlockPos placePos, BlockPos clickedBlock, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(clickedBlock);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            BlockPos commonOrigin = tendrilBlockEntity.getOrigin();
            BlockEntity blockEntity2 = level.getBlockEntity(commonOrigin);
            if (blockEntity2 instanceof SculkTendrilBlockEntity) {
                SculkTendrilBlockEntity originEntity = (SculkTendrilBlockEntity)blockEntity2;
                this.cachedTendrilTree = originEntity.getTendrilTreeGraph();
                this.updateGraphOnPlace(this.cachedTendrilTree, placePos, clickedBlock);
                return true;
            }
        } else if (level.getBlockState(clickedBlock).is(Blocks.SCULK)) {
            this.cachedTendrilTree = new TendrilTree(placePos);
            return true;
        }
        return false;
    }

    private void updateGraphOnPlace(@Nullable TendrilTree tendrilTree, BlockPos myPos, BlockPos parent) {
        if (tendrilTree == null) {
            return;
        }
        tendrilTree.addNode(myPos, parent);
    }

    public void recursiveWidthUpdate(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            Block block;
            BlockPos parentPos;
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            level.scheduleTick(pos, (Block)this, 1);
            TendrilTree tendrilTree = tendrilBlockEntity.getRelativeTendrilTreeGraph();
            if (tendrilTree != null && (parentPos = tendrilTree.getParentOf(pos)) != null && (block = level.getBlockState(parentPos).getBlock()) instanceof SculkTendrilBlock) {
                SculkTendrilBlock parentTendril = (SculkTendrilBlock)block;
                parentTendril.recursiveWidthUpdate(level, tendrilTree.getParentOf(pos), pos, 1);
            }
        }
    }

    private void recursiveWidthUpdate(Level level, BlockPos pos, BlockPos fromPos, int depth) {
        if (depth > 64) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            level.scheduleTick(pos, (Block)this, depth);
            TendrilTree tendrilTree = tendrilBlockEntity.getRelativeTendrilTreeGraph();
            if (tendrilTree != null) {
                Block block;
                BlockPos parentPos = tendrilTree.getParentOf(pos);
                if (parentPos != null && (block = level.getBlockState(parentPos).getBlock()) instanceof SculkTendrilBlock) {
                    SculkTendrilBlock parentTendril = (SculkTendrilBlock)block;
                    parentTendril.recursiveWidthUpdate(level, tendrilTree.getParentOf(pos), fromPos, depth + 1);
                }
                for (BlockPos childPos : tendrilTree.getChildrenOf(pos)) {
                    Block block2;
                    if (this.blockEquals(childPos, fromPos) || !((block2 = level.getBlockState(childPos).getBlock()) instanceof SculkTendrilBlock)) continue;
                    SculkTendrilBlock childTendril = (SculkTendrilBlock)block2;
                    childTendril.recursiveWidthUpdateToChildren(level, childPos, depth + 1);
                }
            }
        }
    }

    private void recursiveWidthUpdateToChildren(Level level, BlockPos pos, int depth) {
        if (depth > 64) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            level.scheduleTick(pos, (Block)this, depth);
            TendrilTree tendrilTree = tendrilBlockEntity.getRelativeTendrilTreeGraph();
            if (tendrilTree != null) {
                for (BlockPos childPos : tendrilTree.getChildrenOf(pos)) {
                    Block block = level.getBlockState(childPos).getBlock();
                    if (!(block instanceof SculkTendrilBlock)) continue;
                    SculkTendrilBlock childTendril = (SculkTendrilBlock)block;
                    childTendril.recursiveWidthUpdateToChildren(level, childPos, depth + 1);
                }
            }
        }
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighbor, boolean b) {
        super.neighborChanged(state, level, pos, block, neighbor, b);
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            TendrilTree tendrilTree = tendrilBlockEntity.getRelativeTendrilTreeGraph();
            if (tendrilTree == null || !tendrilTree.hasNode(pos)) {
                level.destroyBlock(pos, true, null);
            } else {
                if (tendrilTree.getParentOf(pos) == null && !this.hasSculkNeighbor(pos, (LevelReader)level)) {
                    level.destroyBlock(pos, true, null);
                }
                this.recursiveWidthUpdate(level, pos);
            }
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity) {
            SculkTendrilBlockEntity tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity;
            tendrilBlockEntity.updateWidth();
        }
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader levelReader, @NotNull BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos supportPosition = pos.relative(direction);
            if (!this.anyTreeCanSupport(supportPosition, levelReader)) continue;
            return true;
        }
        return this.hasSculkNeighbor(pos, levelReader);
    }

    private boolean anyTreeCanSupport(BlockPos supportPosition, LevelReader levelReader) {
        SculkTendrilBlockEntity tendrilBlockEntity;
        TendrilTree tendrilTree;
        BlockEntity blockEntity = levelReader.getBlockEntity(supportPosition);
        if (blockEntity instanceof SculkTendrilBlockEntity && (tendrilTree = (tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity).getRelativeTendrilTreeGraph()) != null) {
            return tendrilTree.canHaveChildren(supportPosition);
        }
        return false;
    }

    private boolean hasSculkNeighbor(BlockPos pos, LevelReader level) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            if (!level.getBlockState(neighborPos).is(Blocks.SCULK)) continue;
            return true;
        }
        return false;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state1, boolean b) {
        SculkTendrilBlockEntity tendrilBlockEntity;
        TendrilTree tendrilTree;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkTendrilBlockEntity && (tendrilTree = (tendrilBlockEntity = (SculkTendrilBlockEntity)blockEntity).getRelativeTendrilTreeGraph()) != null) {
            tendrilTree.recursiveRemove(pos);
        }
        super.onRemove(state, level, pos, state1, b);
    }

    private boolean blockEquals(BlockPos pos1, BlockPos pos2) {
        return pos1.getX() == pos2.getX() && pos1.getY() == pos2.getY() && pos1.getZ() == pos2.getZ();
    }
}

