/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.util.CustomEnergyStorage;
import wardentools.blockentity.util.TickableBlockEntity;
import wardentools.gui.menu.RadianceCatalystMenu;
import wardentools.items.ItemRegistry;
import wardentools.items.recipe.ModRecipes;
import wardentools.items.recipe.RadianceCatalystRecipe;
import wardentools.items.recipe.RadianceCatalystRecipeInput;
import wardentools.network.payloads.special_effects.RadianceCatalystChargedParticleSound;
import wardentools.network.payloads.special_effects.RadianceCatalystChargingParticleSound;
import wardentools.network.payloads.special_effects.RadianceCatalystPurifyingParticleSound;
import wardentools.particle.ParticleRegistry;

public class RadianceCatalystBlockEntity
extends BlockEntity
implements TickableBlockEntity,
MenuProvider {
    public static final ParticleOptions PARTICLE = (ParticleOptions)ParticleRegistry.RADIANCE.get();
    private static final Component TITLE = Component.translatable((String)"container.wardentools.radiance_catalyst_block");
    private final ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            RadianceCatalystBlockEntity.this.setChanged();
        }
    };
    private int tickFractionner = 0;
    private final CustomEnergyStorage energy = new CustomEnergyStorage(1000, 0, 100, 0);
    private int burnTime;
    private int maxBurnTime = 0;
    public static final int purifyTime = 200;
    private int purifyingTime = 0;
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> RadianceCatalystBlockEntity.this.energy.getEnergyStored();
                case 1 -> RadianceCatalystBlockEntity.this.energy.getMaxEnergyStored();
                case 2 -> RadianceCatalystBlockEntity.this.burnTime;
                case 3 -> RadianceCatalystBlockEntity.this.maxBurnTime;
                case 4 -> RadianceCatalystBlockEntity.this.purifyingTime;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    RadianceCatalystBlockEntity.this.energy.setEnergy(value);
                    break;
                }
                case 2: {
                    RadianceCatalystBlockEntity.this.burnTime = value;
                    break;
                }
                case 3: {
                    RadianceCatalystBlockEntity.this.maxBurnTime = value;
                    break;
                }
                case 4: {
                    RadianceCatalystBlockEntity.this.purifyingTime = value;
                }
            }
        }

        public int getCount() {
            return 5;
        }
    };

    public RadianceCatalystBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.RADIANCE_CATALYST_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.isEmpty()) {
            return;
        }
        if (tag.contains("Inventory", 10)) {
            this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
        }
        if (tag.contains("Energy", 3)) {
            this.energy.setEnergy(tag.getInt("Energy"));
        }
        if (tag.contains("BurnTime", 3)) {
            this.burnTime = tag.getInt("BurnTime");
        }
        if (tag.contains("MaxBurnTime", 3)) {
            this.maxBurnTime = tag.getInt("MaxBurnTime");
        }
        if (tag.contains("PurifyingTime", 3)) {
            this.purifyingTime = tag.getInt("PurifyingTime");
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.putInt("BurnTime", this.burnTime);
        tag.putInt("MaxBurnTime", this.maxBurnTime);
        tag.putInt("PurifyingTime", this.purifyingTime);
    }

    @Override
    public void tick() {
        ++this.tickFractionner;
        if (this.level != null && !this.level.isClientSide()) {
            if (this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                if (this.burnTime <= 0) {
                    if (this.canBurn(this.inventory.getStackInSlot(0))) {
                        this.burnTime = this.maxBurnTime = this.getBurnTime(this.inventory.getStackInSlot(0));
                        this.inventory.getStackInSlot(0).shrink(1);
                        this.sendUpdate();
                    }
                } else {
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.getBlockPos()).getPos(), (CustomPacketPayload)new RadianceCatalystChargingParticleSound(this.getBlockPos().getCenter().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    --this.burnTime;
                    this.energy.addEnergy(1);
                    this.sendUpdate();
                }
            } else if (this.purifyingTime > 0 && this.purifyingTime < 200) {
                if (!this.canPurify(this.inventory.getStackInSlot(1))) {
                    this.purifyingTime = 0;
                    this.sendUpdate();
                } else {
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.getBlockPos()).getPos(), (CustomPacketPayload)new RadianceCatalystPurifyingParticleSound(this.getBlockPos().getCenter().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ++this.purifyingTime;
                    if (this.purifyingTime >= 200) {
                        this.purifyingTime = 0;
                        if (this.inventory.getStackInSlot(2).isEmpty()) {
                            this.energy.setEnergy(this.energy.getEnergyStored() - this.energyCost(this.inventory.getStackInSlot(1)));
                            if (this.getPurifiedVersion(this.inventory.getStackInSlot(1)) != null) {
                                this.inventory.setStackInSlot(2, this.getPurifiedVersion(this.inventory.getStackInSlot(1)));
                                this.inventory.getStackInSlot(1).shrink(1);
                            }
                        } else if (ItemStack.isSameItem((ItemStack)this.inventory.getStackInSlot(2), (ItemStack)this.getPurifiedVersion(this.inventory.getStackInSlot(1)))) {
                            this.energy.setEnergy(this.energy.getEnergyStored() - this.energyCost(this.inventory.getStackInSlot(1)));
                            this.inventory.getStackInSlot(2).grow(1);
                            this.inventory.getStackInSlot(1).shrink(1);
                        }
                    }
                    this.sendUpdate();
                }
            } else if (this.canPurify(this.inventory.getStackInSlot(1)) && (this.inventory.getStackInSlot(2).isEmpty() || ItemStack.isSameItem((ItemStack)this.inventory.getStackInSlot(2), (ItemStack)this.getPurifiedVersion(this.inventory.getStackInSlot(1))))) {
                ++this.purifyingTime;
                this.sendUpdate();
            } else if (this.tickFractionner % 5 == 1) {
                PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.getBlockPos()).getPos(), (CustomPacketPayload)new RadianceCatalystChargedParticleSound(this.getBlockPos().getCenter().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new RadianceCatalystMenu(containerId, playerInventory, this, this.containerData);
    }

    private void sendUpdate() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @NotNull
    public Component getDisplayName() {
        return TITLE;
    }

    public int getBurnTime(@NotNull ItemStack stack) {
        if (stack.is((Item)ItemRegistry.RADIANCE_FRAGMENT.get())) {
            return 51;
        }
        if (stack.is((Item)ItemRegistry.RADIANCE_CRISTAL.get())) {
            return 251;
        }
        return 0;
    }

    @Nullable
    private RadianceCatalystRecipe getRecipeFor(ItemStack input) {
        if (this.level == null) {
            return null;
        }
        RecipeHolder recipe = this.level.getRecipeManager().getRecipeFor(ModRecipes.RADIANCE_RECIPE_TYPE.get(), (RecipeInput)new RadianceCatalystRecipeInput(input), this.level).orElse(null);
        return recipe != null ? (RadianceCatalystRecipe)recipe.value() : null;
    }

    public ItemStack getPurifiedVersion(ItemStack stack) {
        RadianceCatalystRecipe recipe = this.getRecipeFor(stack);
        return recipe != null ? recipe.output().copy() : ItemStack.EMPTY;
    }

    public int energyCost(ItemStack stack) {
        RadianceCatalystRecipe recipe = this.getRecipeFor(stack);
        return recipe != null ? recipe.energyCost() : this.energy.getMaxEnergyStored();
    }

    public boolean canBurn(@NotNull ItemStack stack) {
        return this.getBurnTime(stack) > 0;
    }

    public boolean canPurify(@NotNull ItemStack stack) {
        return !stack.isEmpty() && this.getRecipeFor(stack) != null;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public CustomEnergyStorage getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy.setEnergy(energy);
    }

    public int getPurifyingTime() {
        return this.purifyingTime;
    }
}

