/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.SoulSpawnerBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ShadowEntity;

@OnlyIn(value=Dist.CLIENT)
public class SoulSpawnerRenderer
implements BlockEntityRenderer<SoulSpawnerBlockEntity> {
    public SoulSpawnerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@NotNull SoulSpawnerBlockEntity soulSpawner, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packLight, int packedOverlay) {
        ShadowEntity entity;
        ShadowEntity shadowEntity;
        if (soulSpawner.getLevel() == null) {
            return;
        }
        if (soulSpawner.getShadowEntity() == null && (shadowEntity = (ShadowEntity)ModEntities.SHADOW.get().create(soulSpawner.getLevel())) != null) {
            shadowEntity.moveTo(soulSpawner.getBlockPos(), 0.0f, 0.0f);
            soulSpawner.setShadowEntity(shadowEntity);
        }
        if ((entity = soulSpawner.getShadowEntity()) != null) {
            poseStack.pushPose();
            float time = (float)soulSpawner.getLevel().getGameTime() + partialTick;
            float tiltX = (float)Math.sin((double)time / 10.0) * 30.0f;
            float tiltZ = (float)Math.cos((double)time / 10.0) * 30.0f;
            float rotY = time * 31.415f % 360.0f;
            poseStack.translate(0.5, 0.2, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(rotY));
            poseStack.mulPose(Axis.XP.rotationDegrees(tiltX));
            poseStack.mulPose(Axis.ZP.rotationDegrees(tiltZ));
            float scale = 0.35f;
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getEntityRenderDispatcher().render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packLight);
            poseStack.popPose();
        }
    }
}

