/*
 * Decompiled with CFR 0.152.
 */
package wardentools.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.gui.menu.DysfunctionningCatalystMenu;

@OnlyIn(value=Dist.CLIENT)
public class DysfunctionningCatalystScreen
extends AbstractContainerScreen<DysfunctionningCatalystMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/dysfunctionning_catalyst_menu.png");
    private static final ResourceLocation TEXTURE_EYES = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/dysfunctionning_catalyst_menu_eye_overlay.png");
    private static final int BAR_LENGTH = 28;
    private static final int BG_COLOR = -7631989;
    private final Random random;
    private final Long seed;

    public DysfunctionningCatalystScreen(DysfunctionningCatalystMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 186;
        this.inventoryLabelY += 20;
        --this.titleLabelY;
        this.random = new Random();
        this.seed = this.random.nextLong();
        this.random.setSeed(this.random.nextLong());
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        guiGraphics.fill(this.leftPos + 32 + ((DysfunctionningCatalystMenu)this.menu).getAmethystProgression(), this.topPos + 22, this.leftPos + 32 + 28, this.topPos + 22 + 2, -7631989);
        guiGraphics.fill(this.leftPos + 32 + ((DysfunctionningCatalystMenu)this.menu).getCitrineProgression(), this.topPos + 49, this.leftPos + 32 + 28, this.topPos + 49 + 2, -7631989);
        guiGraphics.fill(this.leftPos + 32 + ((DysfunctionningCatalystMenu)this.menu).getEchoProgression(), this.topPos + 77, this.leftPos + 32 + 28, this.topPos + 77 + 2, -7631989);
        guiGraphics.fill(this.leftPos + 116, this.topPos + 22, this.leftPos + 116 + 28 - ((DysfunctionningCatalystMenu)this.menu).getRubyProgression(), this.topPos + 22 + 2, -7631989);
        guiGraphics.fill(this.leftPos + 116, this.topPos + 49, this.leftPos + 116 + 28 - ((DysfunctionningCatalystMenu)this.menu).getMalachiteProgression(), this.topPos + 49 + 2, -7631989);
        guiGraphics.fill(this.leftPos + 116, this.topPos + 77, this.leftPos + 116 + 28 - ((DysfunctionningCatalystMenu)this.menu).getPaleProgression(), this.topPos + 77 + 2, -7631989);
        this.renderCenterFilling(guiGraphics, this.leftPos + 61, this.topPos + 15, ((DysfunctionningCatalystMenu)this.menu).getTotalCharge());
        if (!((DysfunctionningCatalystMenu)this.menu).getBlockEntity().isContagionDefeated()) {
            this.renderEyes(guiGraphics);
        }
    }

    private void renderEyes(@NotNull GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)((DysfunctionningCatalystMenu)this.menu).getEyeProgression() / 40.0f));
        guiGraphics.blit(TEXTURE_EYES, this.leftPos + 61, this.topPos + 44, 0.0f, 0.0f, 54, 20, 54, 20);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderCenterFilling(@NotNull GuiGraphics guiGraphics, int left, int top, int totalCharge) {
        this.random.setSeed(this.seed);
        int maxTotal = 72;
        float p_min = 1.0f - (float)totalCharge / (float)maxTotal;
        int yMax = top + maxTotal;
        for (int y = top; y < maxTotal + top; ++y) {
            float heightFactor = 1.0f - (float)(y - top) / ((float)yMax - (float)top);
            float probability = p_min * p_min * (heightFactor *= 1.0f / (1.0f - p_min + 1.0E-5f));
            for (int x = left; x < left + 54; ++x) {
                if (!(this.random.nextFloat() < probability)) continue;
                guiGraphics.fill(x, y, x + 1, y + 1, -7631989);
            }
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

