/*
 * Decompiled with CFR 0.152.
 */
package wardentools.datagen.loot;

import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.ModEntities;
import wardentools.items.ItemRegistry;

public class ModEntitiesLootTables
extends EntityLootSubProvider {
    public ModEntitiesLootTables(HolderLookup.Provider provider) {
        this(FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected ModEntitiesLootTables(FeatureFlagSet flagSet, HolderLookup.Provider provider) {
        super(flagSet, provider);
    }

    public void generate() {
        this.add(ModEntities.CONTAGION_INCARNATION.get(), LootTable.lootTable());
        this.add(ModEntities.SHADOW.get(), LootTable.lootTable());
        this.add(ModEntities.PALE_WANDERER.get(), LootTable.lootTable().withPool(this.rareDropPool((ItemLike)ItemRegistry.WANDERER_PAW.get(), 1, 1, 0.5f)));
        this.add(ModEntities.DEEPLURKER.get(), LootTable.lootTable().withPool(this.rareDropPool((ItemLike)ItemRegistry.LURKER_EYE.get(), 1, 2, 0.6f)));
        this.add(ModEntities.TEMPER.get(), LootTable.lootTable().withPool(this.simpleLootPool((ItemLike)ItemRegistry.PALE_SHARD.get(), 0, 3)));
        this.add(ModEntities.PARASYTE.get(), LootTable.lootTable());
        this.add(ModEntities.PROTECTOR.get(), LootTable.lootTable());
        this.add(ModEntities.NOCTILURE.get(), LootTable.lootTable().withPool(this.simpleLootPool((ItemLike)ItemRegistry.NOCTILURE_FEATHER.get(), 1, 2)));
    }

    private LootPool.Builder simpleLootPool(ItemLike item, int minCount, int maxCount) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount, (float)maxCount))));
    }

    private LootPool.Builder rareDropPool(ItemLike item, int minCount, int maxCount, float dropChance) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minCount, (float)maxCount)))).when(LootItemRandomChanceCondition.randomChance((float)dropChance));
    }

    @NotNull
    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return Stream.of(ModEntities.CONTAGION_INCARNATION.get(), ModEntities.SHADOW.get(), ModEntities.PALE_WANDERER.get(), ModEntities.DEEPLURKER.get(), ModEntities.TEMPER.get(), ModEntities.PARASYTE.get(), ModEntities.PROTECTOR.get(), ModEntities.NOCTILURE.get());
    }
}

