/*
 * Decompiled with CFR 0.152.
 */
package wardentools.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.TemperEntity;

public class RadianceBringerEffect
extends MobEffect {
    private static final int RADIUS_FOR_SPAWN = 3;
    private static final int MAX_NUMBER_OF_TEMPER = 3;

    protected RadianceBringerEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.tickCount % (200 / (amplifier + 1)) != 0) {
            return true;
        }
        if (!(entity instanceof Player)) {
            return true;
        }
        if (this.countMyTemper(entity.level(), (Player)entity) >= 3) {
            return true;
        }
        TemperEntity temper = (TemperEntity)ModEntities.TEMPER.get().create(entity.level());
        if (temper == null) {
            return true;
        }
        BlockPos spawnPos = this.findSpawnPosition(entity.level(), entity.getOnPos());
        if (spawnPos == null) {
            return true;
        }
        temper.moveTo((float)spawnPos.getX() + 0.5f, (float)spawnPos.getY() + 0.5f, (float)spawnPos.getZ() + 0.5f);
        temper.setPlayerInvoker((Player)entity);
        entity.level().addFreshEntity((Entity)temper);
        return super.applyEffectTick(entity, amplifier);
    }

    private BlockPos findSpawnPosition(Level level, BlockPos origin) {
        for (int r = 1; r <= 3; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos pos;
                    if (Math.abs(dx) != r && Math.abs(dz) != r || !level.getBlockState(pos = origin.offset(dx, 0, dz)).isAir()) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private int countMyTemper(Level level, Player player) {
        if (player == null) {
            return 0;
        }
        List entities = level.getEntitiesOfClass(TemperEntity.class, new AABB(player.getX() - 30.0, player.getY() - 30.0, player.getZ() - 30.0, player.getX() + 30.0, player.getY() + 30.0, player.getZ() + 30.0));
        int cnt = 0;
        for (TemperEntity temper : entities) {
            if (temper.getOwner() == null || !temper.getOwner().is((Entity)player)) continue;
            ++cnt;
        }
        return cnt;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

