/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.client.DeepLurker;
import wardentools.entity.client.DeepLurkerEyesLayer;
import wardentools.entity.custom.DeepLurkerEntity;

@OnlyIn(value=Dist.CLIENT)
public class DeepLurkerRenderer
extends MobRenderer<DeepLurkerEntity, DeepLurker> {
    private static final ResourceLocation DEEPLURKER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/deeplurker.png");

    public DeepLurkerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DeepLurker(context.bakeLayer(DeepLurker.LAYER_LOCATION)), 0.5f);
        this.addLayer(new DeepLurkerEyesLayer((RenderLayerParent<DeepLurkerEntity, DeepLurker>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull DeepLurkerEntity pEntity) {
        return DEEPLURKER_TEXTURE;
    }

    public void render(DeepLurkerEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.isBaby()) {
            pMatrixStack.scale(0.5f, 0.5f, 0.5f);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

