/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.ParasyteAnimation;
import wardentools.entity.custom.ParasyteEntity;

@OnlyIn(value=Dist.CLIENT)
public class Parasyte
extends HierarchicalModel<ParasyteEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"parasyte"), "main");
    private final ModelParts parts;

    public Parasyte(ModelPart root) {
        ModelPart FULL = root.getChild("FULL");
        ModelPart BODY = FULL.getChild("BODY");
        ModelPart FIN_L1 = BODY.getChild("FIN_L1");
        ModelPart FIN_R1 = BODY.getChild("FIN_R1");
        ModelPart BODY2 = BODY.getChild("BODY2");
        ModelPart TAIL_1 = BODY.getChild("TAIL_1");
        ModelPart TAIL_2 = TAIL_1.getChild("TAIL_2");
        ModelPart FIN_R2 = BODY.getChild("FIN_R2");
        ModelPart FIN_L2 = BODY.getChild("FIN_L2");
        ModelPart HEAD = FULL.getChild("HEAD");
        this.parts = new ModelParts(FULL, BODY, HEAD, FIN_L1, FIN_R1, BODY2, TAIL_1, TAIL_2, FIN_R2, FIN_L2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition BODY = FULL.addOrReplaceChild("BODY", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition FIN_L1 = BODY.addOrReplaceChild("FIN_L1", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-1.0f, (float)1.0f));
        PartDefinition fin_l1_r1 = FIN_L1.addOrReplaceChild("fin_l1_r1", CubeListBuilder.create().texOffs(0, 14).addBox(0.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.0036f, (float)0.0f));
        PartDefinition FIN_R1 = BODY.addOrReplaceChild("FIN_R1", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-1.0f, (float)1.0f));
        PartDefinition fin_r1_r1 = FIN_R1.addOrReplaceChild("fin_r1_r1", CubeListBuilder.create().texOffs(4, 14).addBox(-2.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0036f, (float)0.0f));
        PartDefinition BODY2 = BODY.addOrReplaceChild("BODY2", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -1.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)1.0f, (float)1.0f));
        PartDefinition TAIL_1 = BODY.addOrReplaceChild("TAIL_1", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition fin_r3_r1 = TAIL_1.addOrReplaceChild("fin_r3_r1", CubeListBuilder.create().texOffs(16, 7).addBox(-1.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.25f, (float)0.75f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition fin_l3_r1 = TAIL_1.addOrReplaceChild("fin_l3_r1", CubeListBuilder.create().texOffs(16, 6).addBox(0.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.25f, (float)0.75f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition TAIL_2 = TAIL_1.addOrReplaceChild("TAIL_2", CubeListBuilder.create().texOffs(12, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition FIN_R2 = BODY.addOrReplaceChild("FIN_R2", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-1.0f, (float)2.5f));
        PartDefinition fin_r2_r1 = FIN_R2.addOrReplaceChild("fin_r2_r1", CubeListBuilder.create().texOffs(16, 4).addBox(-2.0f, -0.5f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)1.0036f, (float)0.0f));
        PartDefinition FIN_L2 = BODY.addOrReplaceChild("FIN_L2", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-1.0f, (float)2.5f));
        PartDefinition fin_l2_r1 = FIN_L2.addOrReplaceChild("fin_l2_r1", CubeListBuilder.create().texOffs(16, 2).addBox(0.0f, -0.5f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.0036f, (float)0.0f));
        PartDefinition HEAD = FULL.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(12, 8).addBox(-1.75f, -1.25f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 14).addBox(-1.5f, -1.75f, -1.25f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(0.0f, -1.75f, -1.25f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.25f, (float)-1.0f, (float)-1.75f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.parts.FULL.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.parts.FULL;
    }

    public void setupAnim(@NotNull ParasyteEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.idleAnimation, ParasyteAnimation.idle, ageInTicks);
        this.animateWalk(ParasyteAnimation.crawl, limbSwing, limbSwingAmount, 1.0f, 2.5f);
    }

    private record ModelParts(ModelPart FULL, ModelPart BODY, ModelPart HEAD, ModelPart FIN_L1, ModelPart FIN_R1, ModelPart BODY2, ModelPart TAIL_1, ModelPart TAIL_2, ModelPart FIN_R2, ModelPart FIN_L2) {
    }
}

