/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.client.Temper;
import wardentools.entity.client.TemperEmissiveLayer;
import wardentools.entity.custom.TemperEntity;

@OnlyIn(value=Dist.CLIENT)
public class TemperRenderer
extends MobRenderer<TemperEntity, Temper> {
    private static final ResourceLocation TEMPER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/entity/temper.png");

    public TemperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new Temper(context.bakeLayer(Temper.LAYER_LOCATION)), 0.4f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer(new TemperEmissiveLayer((RenderLayerParent<TemperEntity, Temper>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TemperEntity pEntity) {
        return TEMPER_TEXTURE;
    }

    public void render(@NotNull TemperEntity temper, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        temper.setClientPartialTick(pPartialTicks);
        super.render((LivingEntity)temper, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

