/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.DysfunctionningCatalystBlockEntity;
import wardentools.effect.ModEffects;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ContagionIncarnationCorpseEntity;
import wardentools.entity.custom.ContagionIncarnationPartManager;
import wardentools.entity.utils.IncarnationBodyRotationControl;
import wardentools.entity.utils.IncarnationMoveControl;
import wardentools.entity.utils.goal.IncarnationAttackGoal;
import wardentools.entity.utils.goal.IncarnationSonicStrikeAttackGoal;
import wardentools.entity.utils.goal.TurnTowardsTargetGoal;
import wardentools.network.payloads.special_effects.ThemeIncarnationStart;
import wardentools.network.payloads.special_effects.ThemeIncarnationStop;
import wardentools.sounds.ModSounds;
import wardentools.utils.SaveUtils;

public class ContagionIncarnationEntity
extends ContagionIncarnationPartManager
implements Enemy {
    public static final double MOV_SPEED = 0.2;
    private final ServerBossEvent bossEvent;
    public static final int CHANCE_OF_SCREAM_ON_HIT = 4;
    public static final int DEATH_DURATION = 200;
    public static final int SPAWN_DURATION = 150;
    public static final int MOVE_DELAY_DURING_SPAWN = 80;
    public static final float SPEED_DURING_SPAWN = 0.05f;
    public static final int SWING_ATTACK_DURATION = 10;
    public static final int SWING_HIT_TICK = 3;
    public static final float ATTACK_RANGE = 5.0f;
    public static final int CHANCE_TO_CORRUPT_ON_HIT = 10;
    public static final int AVERAGE_TICK_BETWEEN_SONIC_STRIKES = 1000;
    public static final int SONIC_STRIKE_DURATION = 100;
    public static final int SONIC_STRIKE_EFFECT_TICK = 22;
    public static final int SONIC_STRIKE_PARTICLE_DURATION = 40;
    public static final int CAN_USE_SONIC_STRIKE_HEALTH_MIN = 500;
    public static final int MUSIC_DURATION = 2490;
    private static final BlockParticleOption SOLID_CORRUPTION_PARTICLE = new BlockParticleOption(ParticleTypes.BLOCK, ((Block)BlockRegistry.SOLID_CORRUPTION.get()).defaultBlockState());
    public int contagionIncarnationDeathTime = 0;
    public final AnimationState dyingAnimationState = new AnimationState();
    public final AnimationState ambient = new AnimationState();
    public final AnimationState idleAmbient = new AnimationState();
    public final AnimationState sprint = new AnimationState();
    public final AnimationState spawnAnimation = new AnimationState();
    public final AnimationState rightSwing = new AnimationState();
    public final AnimationState leftSwing = new AnimationState();
    public final AnimationState sonicStrike = new AnimationState();
    private static final EntityDataAccessor<Integer> tickSpawn = SynchedEntityData.defineId(ContagionIncarnationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> rightSwingTick = SynchedEntityData.defineId(ContagionIncarnationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> leftSwingTick = SynchedEntityData.defineId(ContagionIncarnationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> sonicStrikeTick = SynchedEntityData.defineId(ContagionIncarnationEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> hasBeenSummonedByCatalyst = SynchedEntityData.defineId(ContagionIncarnationEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private BlockPos catalystPos = new BlockPos(0, 0, 0);
    private BlockPos lastSonicStrikePos = new BlockPos(0, 0, 0);
    private int deferredSonicStrikeTick = 0;
    private int tickSinceLastMusicPlayed = 0;

    public ContagionIncarnationEntity(EntityType<? extends Monster> entity, Level level) {
        super(entity, level);
        this.bossEvent = new ServerBossEvent(Objects.requireNonNull(this.getDisplayName()), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        this.bossEvent.setPlayBossMusic(false);
        this.xpReward = 200;
        this.setPersistenceRequired();
        this.overrideDefaultParameters();
        this.moveControl = new IncarnationMoveControl(this);
        this.setHasBeenSummonedByCatalyst(false);
        this.noCulling = true;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new IncarnationSonicStrikeAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new IncarnationAttackGoal(this, 2.0));
        this.goalSelector.addGoal(3, (Goal)new TurnTowardsTargetGoal(this, 2.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal(this, (PathfinderMob)this, 2.0){

            public boolean canUse() {
                return ((ContagionIncarnationEntity)this.mob).getSonicStrikeTick() == 0 && super.canUse();
            }

            public boolean canContinueToUse() {
                return ((ContagionIncarnationEntity)this.mob).getSonicStrikeTick() == 0 && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 80.0);
    }

    public void startSeenByPlayer(@NotNull ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ThemeIncarnationStart(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ThemeIncarnationStop(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        super.remove(reason);
        this.bossEvent.removeAllPlayers();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    public int getMaxHeadYRot() {
        return 80;
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 120.0f;
    }

    @Override
    public void tick() {
        if (this.level().isClientSide()) {
            this.handleAnimationStates();
            this.handleSonicStrikeParticleEffect();
        } else {
            if (this.hasBeenSummonedByCatalyst()) {
                this.clientMusicManager();
            }
            this.handleSpawnLogic();
            this.updateSynchronizedTicks();
            this.randomSonicAttackTrigger();
        }
        super.tick();
    }

    private void clientMusicManager() {
        if (this.tickSinceLastMusicPlayed >= 2490) {
            this.tickSinceLastMusicPlayed = 0;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ThemeIncarnationStart(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            ++this.tickSinceLastMusicPlayed;
        }
    }

    private void handleSonicStrikeParticleEffect() {
        if (this.getSonicStrikeTick() == 99) {
            this.lastSonicStrikePos = this.blockPosition();
        }
        if (this.getSonicStrikeTick() == 22) {
            this.deferredSonicStrikeTick = 40;
        }
        if (this.deferredSonicStrikeTick > 0) {
            double baseRadius = 2.0;
            double growthRate = 0.4f;
            double particleNumberRate = 0.1f;
            double heightOffset = 0.5;
            int currentTick = 40 - this.deferredSonicStrikeTick;
            int particlesPerCircle = (int)((double)(25 * currentTick) * particleNumberRate);
            double radius = baseRadius + growthRate * (double)currentTick;
            Vec3 center = Vec3.atCenterOf((Vec3i)this.lastSonicStrikePos);
            double circleHeight = heightOffset / (double)Mth.sqrt((float)currentTick);
            for (int i = 0; i < particlesPerCircle; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particlesPerCircle;
                double xOffset = Math.cos(angle) * radius;
                double zOffset = Math.sin(angle) * radius;
                this.level().addParticle((ParticleOptions)SOLID_CORRUPTION_PARTICLE, center.x + xOffset, center.y, center.z + zOffset, 0.0, circleHeight, 0.0);
            }
        }
        if (this.deferredSonicStrikeTick > 0) {
            --this.deferredSonicStrikeTick;
        }
    }

    private void randomSonicAttackTrigger() {
        if (this.random.nextInt(1000) == 0 && this.getHealth() <= 500.0f && this.getTarget() != null && this.getSonicStrikeTick() == 0) {
            this.setSonicStrikeTick(100);
        }
    }

    private void updateSynchronizedTicks() {
        if (this.getRightSwingTick() > 0) {
            this.setRightSwingTick(this.getRightSwingTick() - 1);
            if (this.getRightSwingTick() == 3) {
                this.hurtTargetAtEndOfSwingIfStillInRange();
            }
        }
        if (this.getLeftSwingTick() > 0) {
            this.setLeftSwingTick(this.getLeftSwingTick() - 1);
            if (this.getLeftSwingTick() == 3) {
                this.hurtTargetAtEndOfSwingIfStillInRange();
            }
        }
        if (this.getSonicStrikeTick() > 0) {
            this.setSonicStrikeTick(this.getSonicStrikeTick() - 1);
        }
    }

    private void handleAnimationStates() {
        this.dyingAnimationState.animateWhen(this.contagionIncarnationDeathTime > 0, this.tickCount);
        this.idleAmbient.animateWhen(!this.isSprinting() && this.isActive(), this.tickCount);
        this.ambient.animateWhen(!this.walkAnimation.isMoving() && this.isActive(), this.tickCount);
        this.sprint.animateWhen(this.isSprinting() && this.isActive(), this.tickCount);
        this.spawnAnimation.animateWhen(this.getTickSpawn() > 0, this.tickCount);
        this.rightSwing.animateWhen(this.getRightSwingTick() > 0, this.tickCount);
        this.leftSwing.animateWhen(this.getLeftSwingTick() > 0, this.tickCount);
        this.sonicStrike.animateWhen(this.getSonicStrikeTick() > 0, this.tickCount);
    }

    private void handleSpawnLogic() {
        if (this.getTickSpawn() > 0) {
            this.setInvulnerable(true);
            this.setTickSpawn(this.getTickSpawn() - 1);
            if (this.getTickSpawn() <= 0) {
                this.setInvulnerable(false);
            }
            this.handleTailSubParts();
            if (this.getTickSpawn() <= 80 && this.getTickSpawn() >= 40) {
                this.setDeltaMovement(this.getYRot() * Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)) * 0.05f, 0.0, this.getYRot() * Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * 0.05f);
            }
        }
    }

    @Override
    public void aiStep() {
        if (this.getTickSpawn() <= 80) {
            super.aiStep();
        }
    }

    public void initiateSpawnAnimation() {
        this.setTickSpawn(150);
    }

    public boolean isActive() {
        return this.getTickSpawn() <= 0 && !this.isDeadOrDying();
    }

    private void hurtTargetAtEndOfSwingIfStillInRange() {
        if (this.getTarget() != null && this.isWithinMeleeAttackRange(this.getTarget()) && this.getSensing().hasLineOfSight((Entity)this.getTarget())) {
            this.doHurtTarget((Entity)this.getTarget());
            if (this.random.nextInt(10) == 0) {
                this.getTarget().addEffect(new MobEffectInstance(ModEffects.CORRUPTED, 100, 0));
            }
        }
    }

    public void swingWithClosestHand() {
        if (this.getTarget() != null) {
            double yaw;
            double dx = this.getTarget().getX() - this.getX();
            double dz = this.getTarget().getZ() - this.getZ();
            double angleToTarget = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
            double angleDifference = (angleToTarget - (yaw = (double)(this.yBodyRot % 360.0f)) + 360.0) % 360.0;
            if (angleDifference > 180.0) {
                angleDifference -= 360.0;
            }
            if (angleDifference > 0.0) {
                this.swingAttackAnimation(InteractionHand.MAIN_HAND);
            } else {
                this.swingAttackAnimation(InteractionHand.OFF_HAND);
            }
        }
    }

    public void swingAttackAnimation(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.setRightSwingTick(10);
        } else {
            this.setLeftSwingTick(10);
        }
    }

    public boolean isWithinMeleeAttackRange(@NotNull LivingEntity entity) {
        return this.distanceTo((Entity)entity) <= 5.0f && this.isInFront(entity, 80.0f);
    }

    private boolean isInFront(LivingEntity entity, float degreeMax) {
        double yaw;
        double dx = entity.getX() - this.getX();
        double dz = entity.getZ() - this.getZ();
        double angleToTarget = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
        double angleDifference = (angleToTarget - (yaw = (double)(this.yBodyRot % 360.0f)) + 360.0) % 360.0;
        if (angleDifference > 180.0) {
            angleDifference -= 360.0;
        }
        return Math.abs(angleDifference) <= (double)degreeMax;
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(tickSpawn, (Object)0);
        entityData.define(rightSwingTick, (Object)0);
        entityData.define(leftSwingTick, (Object)0);
        entityData.define(sonicStrikeTick, (Object)0);
        entityData.define(hasBeenSummonedByCatalyst, (Object)false);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("tickSpawn", this.getTickSpawn());
        SaveUtils.putBlockPos(tag, "catalystPos", this.catalystPos);
        tag.putInt("rightSwingTick", this.getRightSwingTick());
        tag.putInt("leftSwingTick", this.getLeftSwingTick());
        tag.putInt("sonicStrikeTick", this.getSonicStrikeTick());
        SaveUtils.putBlockPos(tag, "lastSonicStrikePos", this.lastSonicStrikePos);
        tag.putBoolean("hasBeenSummonedByCatalyst", ((Boolean)this.entityData.get(hasBeenSummonedByCatalyst)).booleanValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setTickSpawn(tag.getInt("tickSpawn"));
        this.catalystPos = SaveUtils.readBlockPos(tag, "catalystPos");
        this.setRightSwingTick(tag.getInt("rightSwingTick"));
        this.setLeftSwingTick(tag.getInt("leftSwingTick"));
        this.setSonicStrikeTick(tag.getInt("sonicStrikeTick"));
        this.lastSonicStrikePos = SaveUtils.readBlockPos(tag, "lastSonicStrikePos");
        this.entityData.set(hasBeenSummonedByCatalyst, (Object)tag.getBoolean("hasBeenSummonedByCatalyst"));
    }

    public void setCatalystPos(BlockPos pos) {
        this.catalystPos = pos;
        this.setHasBeenSummonedByCatalyst(true);
    }

    public BlockPos getCatalystPos() {
        return this.catalystPos;
    }

    public void setTickSpawn(int tickSpawn) {
        this.entityData.set(ContagionIncarnationEntity.tickSpawn, (Object)tickSpawn);
    }

    public int getTickSpawn() {
        return (Integer)this.entityData.get(tickSpawn);
    }

    public void setRightSwingTick(int rightSwingTick) {
        this.entityData.set(ContagionIncarnationEntity.rightSwingTick, (Object)rightSwingTick);
    }

    public int getRightSwingTick() {
        return (Integer)this.entityData.get(rightSwingTick);
    }

    public void setLeftSwingTick(int leftSwingTick) {
        this.entityData.set(ContagionIncarnationEntity.leftSwingTick, (Object)leftSwingTick);
    }

    public int getLeftSwingTick() {
        return (Integer)this.entityData.get(leftSwingTick);
    }

    public void setSonicStrikeTick(int sonicStrikeTick) {
        this.entityData.set(ContagionIncarnationEntity.sonicStrikeTick, (Object)sonicStrikeTick);
    }

    public int getSonicStrikeTick() {
        return (Integer)this.entityData.get(sonicStrikeTick);
    }

    public boolean hasBeenSummonedByCatalyst() {
        return (Boolean)this.entityData.get(hasBeenSummonedByCatalyst);
    }

    private void setHasBeenSummonedByCatalyst(boolean hasBeenSummonedByCatalyst) {
        this.entityData.set(ContagionIncarnationEntity.hasBeenSummonedByCatalyst, (Object)hasBeenSummonedByCatalyst);
    }

    public static boolean canSpawn(EntityType<ContagionIncarnationEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor p_21686_, @NotNull MobSpawnType p_21687_) {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.CONTAGION_INCARNATION_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        if (this.level().random.nextInt(4) == 0) {
            return ModSounds.CONTAGION_INCARNATION_SCREAM.get();
        }
        return null;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return ModSounds.CONTAGION_INCARNATION_DEATH.get();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.playSound(ModSounds.CONTAGION_INCARNATION_CRAWL.get(), 1.0f, 1.0f);
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    protected void tickDeath() {
        ++this.contagionIncarnationDeathTime;
        if (this.contagionIncarnationDeathTime >= 200 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
            this.createCorpse();
            this.informCatalystOfDeath();
        }
    }

    public void die(@NotNull DamageSource source) {
        if (!this.isRemoved() && !this.dead) {
            Entity entity = source.getEntity();
            LivingEntity livingentity = this.getKillCredit();
            if (this.deathScore >= 0 && livingentity != null) {
                livingentity.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.killedEntity(serverlevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverlevel, source);
                    this.createWitherRose(livingentity);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
        }
    }

    private void createCorpse() {
        ContagionIncarnationCorpseEntity corpse = new ContagionIncarnationCorpseEntity(ModEntities.CONTAGION_INCARNATION_CORPSE.get(), this.level());
        corpse.setPos(this.getX(), this.getY(), this.getZ());
        corpse.setYRot(this.getYRot());
        corpse.setYHeadRot(this.getYHeadRot());
        corpse.setYBodyRot(this.yBodyRot);
        corpse.setHealth(corpse.getMaxHealth());
        this.level().addFreshEntity((Entity)corpse);
    }

    private void informCatalystOfDeath() {
        BlockEntity blockEntity = this.level().getBlockEntity(this.catalystPos);
        if (blockEntity instanceof DysfunctionningCatalystBlockEntity) {
            DysfunctionningCatalystBlockEntity catalyst = (DysfunctionningCatalystBlockEntity)blockEntity;
            catalyst.contagionDied();
        }
    }

    protected boolean canRide(@NotNull Entity entity) {
        return false;
    }

    public boolean isInWall() {
        return false;
    }

    private void overrideDefaultParameters() {
        Field field;
        try {
            field = Mob.class.getDeclaredField("bodyRotationControl");
            field.setAccessible(true);
            field.set((Object)this, (Object)new IncarnationBodyRotationControl((Mob)this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.out.println("Failed to set custom body rotation control for Contagion Incarnation.");
            e.printStackTrace();
        }
        try {
            field = Entity.class.getDeclaredField("eyeHeight");
            field.setAccessible(true);
            field.set((Object)this, Float.valueOf(4.5f));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.out.println("Failed to set custom eye height for Contagion Incarnation.");
            e.printStackTrace();
        }
    }

    public boolean removeWhenFarAway(double v) {
        return false;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        }
    }
}

