/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.block.CrystalBlock;
import wardentools.entity.custom.CrystalGolemEntity;
import wardentools.misc.Crystal;
import wardentools.particle.ModParticleUtils;
import wardentools.particle.options.ShineParticleOptions;
import wardentools.sounds.ModSounds;

public class CrystalLaserEntity
extends Entity {
    private static final EntityDataAccessor<Integer> CRYSTAL = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> TARGET_1 = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> TARGET_2 = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> TARGET_3 = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> TARGET_4 = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<BlockPos> TARGET_5 = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ACTIVE_SEGMENT = SynchedEntityData.defineId(CrystalLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final float DAMAGE = 15.0f;
    private static final float LASER_THICKNESS = 0.5f;
    private static final int TICK_BETWEEN_SEGMENT_CHANGE = 10;
    private static final int PARTICLE_PER_TICK = 5;
    private static final int STATIC_PARTICLE_PER_TICK = 2;
    private static final int SEARCH_RADIUS = 10;
    private static final int SEARCH_HEIGHT = 2;
    private int ticksExisted = 0;
    private boolean firstCrystalHasBeenLit = false;
    private List<Vec3> cachedTargets = List.of();

    public CrystalLaserEntity(EntityType<? extends CrystalLaserEntity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public void onAddedToLevel() {
        this.playBlastSound();
        super.onAddedToLevel();
    }

    public void tick() {
        ++this.ticksExisted;
        if (!this.firstCrystalHasBeenLit && this.getTarget(0) != BlockPos.ZERO) {
            this.litCrystal(this.getTarget(0), true);
            this.firstCrystalHasBeenLit = true;
        }
        if (this.ticksExisted > this.getLifeSpan()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            if (this.getActiveSegment() != this.getSize() - 1) {
                this.playBlastSound();
            }
            this.updateActiveSegment();
            this.litCrystals();
        }
        if (this.level().isClientSide) {
            this.handleParticleAnimation();
        } else {
            this.damageEntityInsideSegment();
        }
        super.tick();
    }

    private void playBlastSound() {
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), ModSounds.LASER_SHOOT.get(), this.getSoundSource(), 0.8f, this.level().getRandom().nextFloat() * 0.2f + 0.9f, false);
    }

    private static double distanceSqPointToSegment(Vec3 p, Vec3 a, Vec3 b) {
        Vec3 ab = b.subtract(a);
        Vec3 ap = p.subtract(a);
        double abLenSq = ab.lengthSqr();
        if (abLenSq == 0.0) {
            return ap.lengthSqr();
        }
        double t = ap.dot(ab) / abLenSq;
        t = Math.max(0.0, Math.min(1.0, t));
        Vec3 closest = a.add(ab.scale(t));
        return p.subtract(closest).lengthSqr();
    }

    private void damageEntityInsideSegment() {
        int activeSegment;
        if (this.cachedTargets.isEmpty()) {
            this.getAllTargets();
        }
        if ((activeSegment = this.getActiveSegment()) >= this.getSize()) {
            return;
        }
        if (activeSegment >= this.cachedTargets.size() - 1) {
            return;
        }
        Vec3 start = this.cachedTargets.get(activeSegment);
        Vec3 end = this.cachedTargets.get(activeSegment + 1);
        AABB broad = new AABB(start, end).inflate(0.5);
        double radiusSq = 0.25;
        for (Entity entity : this.level().getEntities((Entity)this, broad)) {
            if (entity instanceof CrystalGolemEntity || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            List<Vec3> testPoints = CrystalLaserEntity.getPointsFromAABB(living);
            boolean hit = false;
            for (Vec3 p : testPoints) {
                if (!(CrystalLaserEntity.distanceSqPointToSegment(p, start, end) <= radiusSq)) continue;
                hit = true;
                break;
            }
            if (!hit) continue;
            living.hurt(this.damageSources().magic(), 15.0f);
        }
    }

    @NotNull
    private static List<Vec3> getPointsFromAABB(LivingEntity living) {
        AABB box = living.getBoundingBox();
        return List.of(box.getCenter(), new Vec3(box.minX, box.minY, box.minZ), new Vec3(box.minX, box.minY, box.maxZ), new Vec3(box.minX, box.maxY, box.minZ), new Vec3(box.minX, box.maxY, box.maxZ), new Vec3(box.maxX, box.minY, box.minZ), new Vec3(box.maxX, box.minY, box.maxZ), new Vec3(box.maxX, box.maxY, box.minZ), new Vec3(box.maxX, box.maxY, box.maxZ));
    }

    private void handleParticleAnimation() {
        int activeSegment = this.getActiveSegment();
        if (activeSegment >= this.getSize()) {
            return;
        }
        if (activeSegment >= this.cachedTargets.size() - 1) {
            return;
        }
        this.dynamicParticleForSegment(activeSegment);
        for (int segment = activeSegment; segment < this.cachedTargets.size() - 1; ++segment) {
            this.staticParticleForSegment(segment);
        }
    }

    private void dynamicParticleForSegment(int segment) {
        if (segment >= this.cachedTargets.size() - 1) {
            return;
        }
        Vec3 start = this.cachedTargets.get(segment);
        Vec3 end = this.cachedTargets.get(segment + 1);
        if (start == null || end == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Vec3 originAlong = start.add(end.subtract(start).scale((double)(this.level().getRandom().nextFloat() * 0.9f))).offsetRandom(this.level().getRandom(), 0.2f);
            Vec3 target = end.offsetRandom(this.level().getRandom(), 0.2f);
            ModParticleUtils.addClientParticle(this.level(), new ShineParticleOptions(Vec3.ZERO, this.getCrystalType().getColor(), true, true), originAlong, target, 0.03f);
        }
    }

    private void staticParticleForSegment(int segment) {
        if (segment >= this.cachedTargets.size() - 1) {
            return;
        }
        Vec3 start = this.cachedTargets.get(segment);
        Vec3 end = this.cachedTargets.get(segment + 1);
        if (start == null || end == null) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            Vec3 originAlong = start.add(end.subtract(start).scale((double)(this.level().getRandom().nextFloat() * 0.9f))).offsetRandom(this.level().getRandom(), 0.2f);
            ModParticleUtils.addStaticClientParticle(this.level(), new ShineParticleOptions(Vec3.ZERO, this.getCrystalType().getColor(), true, false), originAlong);
        }
    }

    private int getLifeSpan() {
        return 10 * this.getSize() + 1;
    }

    private void updateActiveSegment() {
        if (this.getActiveSegment() < this.getSize()) {
            this.setActiveSegment(this.getActiveSegment() + 1);
        }
    }

    private void litCrystals() {
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = this.getTarget(i);
            boolean isLit = this.getActiveSegment() == i || this.getActiveSegment() == i + 1;
            this.litCrystal(pos, isLit);
        }
    }

    private void unlitAllCrystals() {
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = this.getTarget(i);
            this.litCrystal(pos, false);
        }
    }

    private void litCrystal(BlockPos pos, boolean lit) {
        BlockState state;
        if (pos != null && pos != BlockPos.ZERO && (state = this.level().getBlockState(pos)).getBlock() instanceof CrystalBlock) {
            this.level().setBlock(pos, (BlockState)state.setValue((Property)CrystalBlock.OVERCHARGED, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    public void buildCrystalChain() {
        List<BlockPos> chain = this.findCrystalChain(5, 10, 2);
        for (int i = 0; i < chain.size(); ++i) {
            BlockPos pos = chain.get(i);
            switch (i) {
                case 0: {
                    this.entityData.set(TARGET_1, (Object)pos);
                    break;
                }
                case 1: {
                    this.entityData.set(TARGET_2, (Object)pos);
                    break;
                }
                case 2: {
                    this.entityData.set(TARGET_3, (Object)pos);
                    break;
                }
                case 3: {
                    this.entityData.set(TARGET_4, (Object)pos);
                    break;
                }
                case 4: {
                    this.entityData.set(TARGET_5, (Object)pos);
                }
            }
            if (pos == null || pos == BlockPos.ZERO) continue;
            this.setSize(i + 1);
        }
    }

    public List<BlockPos> findCrystalChain(int maxTargets, int maxRadius, int maxHeight) {
        BlockPos next;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos currentOrigin = this.blockPosition();
        for (int i = 0; i < maxTargets && (next = this.findClosestCrystal(currentOrigin, maxRadius, maxHeight, result)) != null; ++i) {
            result.add(next);
            currentOrigin = next;
        }
        return result;
    }

    private BlockPos findClosestCrystal(BlockPos origin, int radius, int height, List<BlockPos> alreadyFound) {
        for (int r = 1; r <= radius; ++r) {
            for (int y = -height; y <= height; ++y) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        BlockPos pos;
                        if (Math.abs(x) != r && Math.abs(z) != r || alreadyFound.contains(pos = origin.offset(x, y, z)) || !CrystalLaserEntity.isLaserCompatible(this.level(), pos, this.getCrystalType())) continue;
                        return pos;
                    }
                }
            }
        }
        return null;
    }

    public List<Vec3> getAllTargets() {
        if (this.cachedTargets.isEmpty()) {
            ArrayList<Vec3> targets = new ArrayList<Vec3>();
            targets.add(this.position());
            for (int i = 0; i < 5; ++i) {
                BlockPos target = this.getTarget(i);
                if (target == BlockPos.ZERO) continue;
                targets.add(target.getCenter());
            }
            this.cachedTargets = List.copyOf(targets);
        }
        return this.cachedTargets;
    }

    public BlockPos getTarget(int index) {
        return switch (index) {
            case 0 -> (BlockPos)this.entityData.get(TARGET_1);
            case 1 -> (BlockPos)this.entityData.get(TARGET_2);
            case 2 -> (BlockPos)this.entityData.get(TARGET_3);
            case 3 -> (BlockPos)this.entityData.get(TARGET_4);
            case 4 -> (BlockPos)this.entityData.get(TARGET_5);
            default -> BlockPos.ZERO;
        };
    }

    public int getActiveSegment() {
        return (Integer)this.entityData.get(ACTIVE_SEGMENT);
    }

    private void setActiveSegment(int i) {
        this.entityData.set(ACTIVE_SEGMENT, (Object)i);
    }

    public int getSize() {
        return (Integer)this.entityData.get(SIZE);
    }

    private void setSize(int size) {
        this.entityData.set(SIZE, (Object)size);
    }

    public static boolean isLaserCompatible(Level level, BlockPos pos, Crystal crystal) {
        return level.getBlockState(pos).is(crystal.getCrystalBud());
    }

    public void setCrystalType(Crystal crystal) {
        this.entityData.set(CRYSTAL, (Object)crystal.getIndex());
    }

    public Crystal getCrystalType() {
        return Crystal.fromIndex((Integer)this.entityData.get(CRYSTAL));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public void onRemovedFromLevel() {
        this.unlitAllCrystals();
        super.onRemovedFromLevel();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(CRYSTAL, (Object)Crystal.getDefault().getIndex());
        builder.define(TARGET_1, (Object)BlockPos.ZERO);
        builder.define(TARGET_2, (Object)BlockPos.ZERO);
        builder.define(TARGET_3, (Object)BlockPos.ZERO);
        builder.define(TARGET_4, (Object)BlockPos.ZERO);
        builder.define(TARGET_5, (Object)BlockPos.ZERO);
        builder.define(SIZE, (Object)0);
        builder.define(ACTIVE_SEGMENT, (Object)0);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }
}

