/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.custom;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.effect.ModEffects;

public class TemperEntity
extends TamableAnimal
implements NeutralMob {
    private static final int attackDurationTick = 10;
    private static final EntityDataAccessor<Integer> attackAnimationTick = SynchedEntityData.defineId(TemperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState attackAnimationState = new AnimationState();
    private Player invoker = null;
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(TemperEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    private static final float MAX_FLAP_ANGLE = 0.47123888f;
    private boolean wingOnAscending = true;
    private float wingAngle = 0.0f;
    private float prevWingAngle = 0.0f;
    private float clientPartialTick = 0.0f;

    public TemperEntity(EntityType<? extends TamableAnimal> entity, Level level) {
        super(entity, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        this.setTame(false, false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 100.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttribute() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, 0.16).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0);
    }

    public void tick() {
        if (this.getAttackTick() > 0) {
            this.setAttackTick(this.getAttackTick() - 1);
        }
        if (this.level().isClientSide()) {
            this.attackAnimationState.animateWhen(this.getAttackTick() > 0, this.tickCount);
            this.flap(2.5f + (float)this.getDeltaMovement().lengthSqr() * 200.0f);
        }
        this.dispawnIfOwnerNotRadianceBringer();
        super.tick();
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        this.setAttackTick(10);
        return super.doHurtTarget(target);
    }

    private void dispawnIfOwnerNotRadianceBringer() {
        if (this.getOwner() == null) {
            return;
        }
        if (this.getOwner().getEffect(ModEffects.RADIANCE_BRINGER) == null) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public int getAttackTick() {
        return (Integer)this.entityData.get(attackAnimationTick);
    }

    public void setAttackTick(int tick) {
        this.entityData.set(attackAnimationTick, (Object)tick);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, @NotNull DamageSource source) {
        return false;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public void travel(@NotNull Vec3 vec) {
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, vec);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, vec);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), vec);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public void setItemInHand(@NotNull InteractionHand hand, @NotNull ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        }
    }

    @NotNull
    public ItemStack getItemInHand(@NotNull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        entityData.define(attackAnimationTick, (Object)0);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
    }

    public boolean isFood(@NotNull ItemStack itemStack) {
        return false;
    }

    public void setPlayerInvoker(Player player) {
        this.invoker = player;
        this.tame(player);
    }

    private void flap(float flapSpeed) {
        this.prevWingAngle = this.wingAngle;
        float newAngle = this.wingAngle + (this.wingOnAscending ? flapSpeed : -flapSpeed) * ((float)Math.PI / 180);
        if (newAngle > 0.47123888f) {
            this.wingOnAscending = false;
        } else if (newAngle < -0.47123888f) {
            this.wingOnAscending = true;
        }
        this.wingAngle = newAngle;
    }

    public float getWingAngle() {
        return Mth.lerp((float)this.clientPartialTick, (float)this.prevWingAngle, (float)this.wingAngle);
    }

    public void setClientPartialTick(float pt) {
        this.clientPartialTick = pt;
    }

    public Player getPlayerInvoker() {
        return this.invoker;
    }

    public boolean canHoldItem(ItemStack stack) {
        return stack.getItem() instanceof SwordItem || super.canHoldItem(stack);
    }

    public boolean isOrderedToSit() {
        return false;
    }

    public void setOrderedToSit(boolean sit) {
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor level, @NotNull MobSpawnType type) {
        return true;
    }

    public static boolean canSpawn(EntityType<TemperEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos).isAir();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.ALLAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ALLAY_DEATH;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return !(entity instanceof Player) && super.canCollideWith(entity);
    }

    protected void doPush(@NotNull Entity entity) {
        if (!(entity instanceof Player)) {
            super.doPush(entity);
        }
    }

    public void push(@NotNull Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(entity instanceof Player)) {
            super.push(entity);
        } else if (!this.isPassengerOfSameVehicle(entity) && !entity.noPhysics && !this.noPhysics && (d2 = Mth.absMax((double)(d0 = entity.getX() - this.getX()), (double)(d1 = entity.getZ() - this.getZ()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
        }
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public boolean wantsToAttack(@NotNull LivingEntity target, @NotNull LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            boolean bl;
            LivingEntity livingEntity = target;
            Objects.requireNonNull(livingEntity);
            LivingEntity livingEntity2 = livingEntity;
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Wolf.class, TemperEntity.class, Player.class, AbstractHorse.class}, (Object)livingEntity2, n)) {
                    case 0: {
                        Wolf wolf = (Wolf)livingEntity2;
                        if (!wolf.isTame() || wolf.getOwner() != owner) {
                            bl = true;
                            break block6;
                        }
                        bl = false;
                        break block6;
                    }
                    case 1: {
                        TemperEntity temperTarget = (TemperEntity)livingEntity2;
                        if (!temperTarget.isTame() || temperTarget.getOwner() != owner) {
                            bl = true;
                            break block6;
                        }
                        bl = false;
                        break block6;
                    }
                    case 2: {
                        Player player = (Player)livingEntity2;
                        if (!(owner instanceof Player) || ((Player)owner).canHarmPlayer(player)) {
                            n = 3;
                            continue block6;
                        }
                        bl = false;
                        break block6;
                    }
                    case 3: {
                        AbstractHorse abstractHorse = (AbstractHorse)livingEntity2;
                        if (!abstractHorse.isTamed()) {
                            n = 4;
                            continue block6;
                        }
                        bl = false;
                        break block6;
                    }
                    default: {
                        if (!(target instanceof TamableAnimal) || !((TamableAnimal)target).isTame()) {
                            bl = true;
                            break block6;
                        }
                        bl = false;
                        break block6;
                    }
                }
                break;
            }
            return bl;
        }
        return false;
    }
}

