/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wardentools.entity.utils.RenderToBufferFunction;
import wardentools.entity.utils.ScaleFunction;
import wardentools.entity.utils.SetUpAnimFunction;
import wardentools.entity.utils.getBobFunction;

@OnlyIn(value=Dist.CLIENT)
public class ClientMimicRenderingUtils {
    public static RenderToBufferFunction getRenderToBufferFunction(LivingEntity mimic) {
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)mimic);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return (poseStack, vertexConsumer, i, j) -> livingRenderer.getModel().renderToBuffer(poseStack, vertexConsumer, i, j);
        }
        return null;
    }

    public static <T extends LivingEntity> SetUpAnimFunction<T> getSetUpAnimFunction(T mimic) {
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(mimic);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((EntityModel)livingRenderer.getModel()).setupAnim(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        }
        return null;
    }

    public static <T extends LivingEntity> getBobFunction<T> getGetBobFunction(T mimic) {
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(mimic);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            try {
                Method getBobMethod = LivingEntityRenderer.class.getDeclaredMethod("getBob", LivingEntity.class, Float.TYPE);
                getBobMethod.setAccessible(true);
                return (entity, partialTicks) -> {
                    if (mimic instanceof Chicken || mimic instanceof Parrot) {
                        return 0.0f;
                    }
                    try {
                        return ((Float)getBobMethod.invoke((Object)livingRenderer, entity, Float.valueOf(partialTicks))).floatValue();
                    }
                    catch (Exception e) {
                        System.out.println("Error invoking getBob method");
                        return 0.0f;
                    }
                };
            }
            catch (NoSuchMethodException e) {
                System.out.println("Error invoking getBob method: NoSuchMethodException");
            }
        }
        return null;
    }

    public static <T extends LivingEntity> ScaleFunction<T> getScaleFunction(T mimic) {
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(mimic);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            try {
                Method scaleMethod = LivingEntityRenderer.class.getDeclaredMethod("scale", LivingEntity.class, PoseStack.class, Float.TYPE);
                scaleMethod.setAccessible(true);
                return (entity, poseStack, v) -> {
                    try {
                        scaleMethod.invoke((Object)livingRenderer, entity, poseStack, Float.valueOf(v));
                    }
                    catch (Exception e) {
                        System.out.println("Error invoking scale method");
                    }
                };
            }
            catch (NoSuchMethodException e) {
                System.out.println("Error invoking scale method: NoSuchMethodException");
            }
        }
        return null;
    }
}

