/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;
import wardentools.entity.custom.ContagionIncarnationEntity;

public class IncarnationMoveControl
extends MoveControl {
    public static final float MIN_SPEED_SQR = 2.5000003E-7f;
    protected static final int MAX_TURN = 10;
    private static final float rad = (float)Math.PI / 180;
    protected final ContagionIncarnationEntity incarnation;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected double speedModifier;
    protected float strafeForwards;
    protected float strafeRight;
    protected Operation operation = Operation.WAIT;

    public IncarnationMoveControl(ContagionIncarnationEntity mob) {
        super((Mob)mob);
        this.incarnation = mob;
    }

    public boolean hasWanted() {
        return this.operation == Operation.MOVE_TO;
    }

    public double getSpeedModifier() {
        return this.speedModifier;
    }

    public void setWantedPosition(double wantedX, double wantedY, double wantedZ, double speedModifier) {
        this.wantedX = wantedX;
        this.wantedY = wantedY;
        this.wantedZ = wantedZ;
        this.speedModifier = speedModifier;
        if (this.operation != Operation.JUMPING) {
            this.operation = Operation.MOVE_TO;
        }
    }

    public void strafe(float strafeForwards, float strafeRight) {
        this.operation = Operation.STRAFE;
        this.strafeForwards = strafeForwards;
        this.strafeRight = strafeRight;
        this.speedModifier = 0.25;
    }

    public void tick() {
        if (this.operation == Operation.STRAFE) {
            float strafeZ;
            float speedAttribute = (float)this.incarnation.getAttributeValue(Attributes.MOVEMENT_SPEED);
            float modifiedSpeed = (float)this.speedModifier * speedAttribute;
            float strafeSpeed = Mth.sqrt((float)(this.strafeForwards * this.strafeForwards + this.strafeRight * this.strafeRight));
            if (strafeSpeed < 1.0f) {
                strafeSpeed = 1.0f;
            }
            strafeSpeed = modifiedSpeed / strafeSpeed;
            this.strafeForwards *= strafeSpeed;
            this.strafeRight *= strafeSpeed;
            float sinYRot = Mth.sin((float)(this.incarnation.getYRot() * ((float)Math.PI / 180)));
            float cosYRot = Mth.cos((float)(this.incarnation.getYRot() * ((float)Math.PI / 180)));
            float strafeX = this.strafeForwards * cosYRot - this.strafeRight * sinYRot;
            if (!this.isWalkable(strafeX, strafeZ = this.strafeRight * cosYRot + this.strafeForwards * sinYRot)) {
                this.strafeForwards = 1.0f;
                this.strafeRight = 0.0f;
            }
            this.incarnation.setSpeed(modifiedSpeed);
            this.incarnation.setZza(this.strafeForwards);
            this.incarnation.setXxa(this.strafeRight);
            this.operation = Operation.WAIT;
        } else if (this.operation == Operation.MOVE_TO) {
            this.operation = Operation.WAIT;
            double dx = this.wantedX - this.incarnation.getX();
            double dy = this.wantedZ - this.incarnation.getZ();
            double dz = this.wantedY - this.incarnation.getY();
            double distSqr = dx * dx + dz * dz + dy * dy;
            if (distSqr < 2.500000277905201E-7) {
                this.incarnation.setZza(0.0f);
                return;
            }
            float targetYaw = (float)Mth.atan2((double)dy, (double)dx) / ((float)Math.PI / 180) - 90.0f;
            this.incarnation.setYRot(this.rotlerp(this.incarnation.getYRot(), targetYaw, 10.0f));
            this.incarnation.setSpeed((float)(this.speedModifier * this.incarnation.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos blockpos = this.incarnation.blockPosition();
            BlockState blockstate = this.incarnation.level().getBlockState(blockpos);
            VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)this.incarnation.level(), blockpos);
            if (dz > (double)this.incarnation.maxUpStep() && dx * dx + dy * dy < (double)Math.max(1.0f, this.incarnation.getBbWidth()) || !voxelshape.isEmpty() && this.incarnation.getY() < voxelshape.max(Direction.Axis.Y) + (double)blockpos.getY() && !blockstate.is(BlockTags.DOORS) && !blockstate.is(BlockTags.FENCES)) {
                this.incarnation.getJumpControl().jump();
                this.operation = Operation.JUMPING;
            }
        } else if (this.operation == Operation.JUMPING) {
            this.incarnation.setSpeed((float)(this.speedModifier * this.incarnation.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.incarnation.onGround()) {
                this.operation = Operation.WAIT;
            }
        } else {
            this.incarnation.setZza(0.0f);
        }
    }

    private boolean isWalkable(float dx, float dy) {
        PathNavigation navigation = this.mob.getNavigation();
        NodeEvaluator nodeEvaluator = navigation.getNodeEvaluator();
        return nodeEvaluator.getPathType(this.mob, BlockPos.containing((double)(this.mob.getX() + (double)dx), (double)this.mob.getBlockY(), (double)(this.mob.getZ() + (double)dy))) == PathType.WALKABLE;
    }

    protected float rotlerp(float currentYaw, float targetYaw, float maxTurn) {
        float newYaw;
        float deltaYaw = Mth.wrapDegrees((float)(targetYaw - currentYaw));
        if (deltaYaw > maxTurn) {
            deltaYaw = maxTurn;
        }
        if (deltaYaw < -maxTurn) {
            deltaYaw = -maxTurn;
        }
        if ((newYaw = currentYaw + deltaYaw) < 0.0f) {
            newYaw += 360.0f;
        } else if (newYaw > 360.0f) {
            newYaw -= 360.0f;
        }
        return newYaw;
    }

    public double getWantedX() {
        return this.wantedX;
    }

    public double getWantedY() {
        return this.wantedY;
    }

    public double getWantedZ() {
        return this.wantedZ;
    }

    protected static enum Operation {
        WAIT,
        MOVE_TO,
        STRAFE,
        JUMPING;

    }
}

