/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.Vec3;
import wardentools.block.BlockRegistry;
import wardentools.entity.custom.DeepLurkerEntity;

public class AvoidWardenAndClimbTreeGoal
extends Goal {
    private final DeepLurkerEntity entity;
    private final double speedModifier;
    private final double climbSpeedModifier;
    private LivingEntity target;
    private BlockPos targetTreePos;
    private static final int scaredRadius = 20;

    public AvoidWardenAndClimbTreeGoal(DeepLurkerEntity entity, double speedModifier, double climbSpeedModifier) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.climbSpeedModifier = climbSpeedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List wardens = this.entity.level().getEntitiesOfClass(Warden.class, this.entity.getBoundingBox().inflate(20.0));
        if (!wardens.isEmpty()) {
            this.target = (LivingEntity)wardens.get(0);
            BlockPos startPos = this.entity.blockPosition();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int y = startPos.getY();
            for (int r = 1; r <= 20; ++r) {
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dz = -r; dz <= r; ++dz) {
                        if (Math.abs(dx) != r && Math.abs(dz) != r) continue;
                        mutableBlockPos.set(startPos.getX() + dx, y, startPos.getZ() + dz);
                        if (this.entity.level().getBlockState((BlockPos)mutableBlockPos).getBlock() != BlockRegistry.DARKTREE_LOG.get()) continue;
                        this.targetTreePos = mutableBlockPos.immutable();
                        this.targetTreePos = this.getTargetOnTree();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void start() {
        if (this.targetTreePos != null) {
            this.entity.getNavigation().moveTo((double)this.targetTreePos.getX(), (double)this.targetTreePos.getY(), (double)this.targetTreePos.getZ(), this.speedModifier);
        }
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.entity.distanceTo((Entity)this.target) < 20.0f && this.entity.level().getBlockState(this.targetTreePos).getBlock() == BlockRegistry.DARKTREE_LOG.get();
    }

    public void stop() {
        this.target = null;
        this.targetTreePos = null;
        this.entity.setClimbing(false);
        this.entity.setNoGravity(false);
        this.entity.setScared(false);
    }

    public void tick() {
        if (this.target != null && this.entity.horizontalCollision && !this.isAtTopOfTree()) {
            this.entity.setClimbing(true);
            this.entity.getNavigation().moveTo((double)this.targetTreePos.getX(), (double)this.targetTreePos.getY(), (double)this.targetTreePos.getZ(), this.climbSpeedModifier);
            this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(0.0, 0.2, 0.0));
        } else if (this.isAtTopOfTree()) {
            this.entity.getLookControl().setLookAt((Entity)this.target);
            this.entity.setDeltaMovement(Vec3.ZERO);
            this.entity.getNavigation().stop();
            this.entity.setNoGravity(true);
            this.entity.setScared(true);
        }
    }

    private boolean isAtTopOfTree() {
        BlockPos pos = this.entity.blockPosition();
        return this.entity.level().getBlockState(pos.above()).getBlock() == BlockRegistry.DARKTREE_LEAVES.get() || this.entity.level().getBlockState(pos.above()).getBlock() == BlockRegistry.DARKTREE_LOG.get();
    }

    private BlockPos getTargetOnTree() {
        if (this.targetTreePos != null) {
            int i;
            for (i = 0; !this.entity.level().getBlockState(this.targetTreePos.above(i)).isAir() && i < 20; ++i) {
            }
            return this.targetTreePos.above(i);
        }
        return null;
    }
}

