/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import wardentools.entity.custom.CrystalGolemEntity;

public class CrystalGolemAttackGoal
extends MeleeAttackGoal {
    private static final int CHANCE_TO_SHOOT_LASER = 250;
    private final CrystalGolemEntity golem;

    public CrystalGolemAttackGoal(CrystalGolemEntity golem, double speedModifier) {
        super((PathfinderMob)golem, speedModifier, true);
        this.golem = golem;
    }

    public boolean canUse() {
        return super.canUse() && this.golem.hasGrief() && this.golem.isActive();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.golem.getState() == CrystalGolemEntity.GolemState.TRAVELING;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public void tick() {
        if (this.golem.getRandom().nextInt(250) == 0) {
            this.golem.setState(CrystalGolemEntity.GolemState.CHARGING_LASER);
        }
        super.tick();
    }
}

