/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import java.util.EnumSet;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import wardentools.entity.custom.ProtectorEntity;

public class ReturnToInvokerGoal
extends Goal {
    private final ProtectorEntity entity;
    private final double speedModifier;
    private final boolean canTeleport;
    private static final int goCloserThan = 5;

    public ReturnToInvokerGoal(ProtectorEntity entity, double speedModifier, boolean canTeleport) {
        this.entity = entity;
        this.speedModifier = speedModifier;
        this.canTeleport = canTeleport;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.entity.invokerPos != null && !this.entity.invokerPos.closerThan((Vec3i)this.entity.blockPosition(), 20.0);
    }

    public void start() {
        this.entity.getNavigation().moveTo((double)this.entity.invokerPos.getX(), (double)this.entity.invokerPos.getY(), (double)this.entity.invokerPos.getZ(), this.speedModifier);
    }

    public boolean canContinueToUse() {
        return this.entity.invokerPos != null && !this.entity.invokerPos.closerThan((Vec3i)this.entity.blockPosition(), 5.0);
    }

    public void tick() {
        if (this.canTeleport && !this.entity.invokerPos.closerThan((Vec3i)this.entity.blockPosition(), 100.0)) {
            this.entity.teleportTo(this.entity.invokerPos.getX() + 1, this.entity.invokerPos.getY(), this.entity.invokerPos.getZ() + 1);
        }
        this.entity.getNavigation().moveTo((double)this.entity.invokerPos.getX(), (double)this.entity.invokerPos.getY(), (double)this.entity.invokerPos.getZ(), this.speedModifier);
        super.tick();
    }

    public void stop() {
        this.entity.getNavigation().stop();
    }
}

