/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.utils.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import wardentools.entity.custom.NoctilureEntity;

public class TakeOffGoal
extends Goal {
    private static final int maxTickCount = 1000;
    private int tickCount = 0;
    private final NoctilureEntity noctilure;
    private Vec3 targetOnTakeOff;

    public TakeOffGoal(NoctilureEntity noctilure) {
        this.noctilure = noctilure;
    }

    public void start() {
        this.tickCount = 0;
        this.setTakeOffTargetOrCancel();
    }

    public boolean canUse() {
        return this.noctilure.getWantsToTakeOff();
    }

    public void tick() {
        ++this.tickCount;
        if (this.noctilure.getNavigation().isDone()) {
            this.noctilure.setWantsToTakeOff(false);
        }
        if (this.targetOnTakeOff == null) {
            this.start();
        }
    }

    private void setTakeOffTargetOrCancel() {
        this.targetOnTakeOff = this.findValidTakeOffPosition();
        if (this.targetOnTakeOff == null) {
            this.noctilure.setWantsToTakeOff(false);
            return;
        }
        if (!this.noctilure.getNavigation().moveTo(this.targetOnTakeOff.x, this.targetOnTakeOff.y, this.targetOnTakeOff.z, (double)0.2f)) {
            this.noctilure.setWantsToTakeOff(false);
        }
    }

    private Vec3 findValidTakeOffPosition() {
        BlockPos entityPos = this.noctilure.blockPosition();
        int maxRange = 10;
        int minRange = 5;
        for (int dx = -maxRange; dx <= maxRange; ++dx) {
            for (int dz = -maxRange; dz <= maxRange; ++dz) {
                if (dx * dx + dz * dz >= minRange * minRange) continue;
                BlockPos checkPos = entityPos.offset(dx, 0, dz);
                if (!this.noctilure.level().getBlockState(checkPos).isAir()) continue;
                return new Vec3((double)checkPos.getX(), (double)this.noctilure.getTargetHeightOnTakeOff() + this.noctilure.getY(), (double)checkPos.getZ());
            }
        }
        return null;
    }

    public boolean canContinueToUse() {
        return this.noctilure.getWantsToTakeOff() && this.tickCount < 1000;
    }

    public void stop() {
        this.tickCount = 0;
        super.stop();
    }
}

