/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import wardentools.entity.custom.NoctilureEntity;

@EventBusSubscriber(modid="wardentools")
public class NoctilureSprintBarGuiRender {
    private static final ResourceLocation SPRINT_BAR_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/sprint_bar/noctilure_background.png");
    private static final ResourceLocation SPRINT_BAR_PROGRESS = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"textures/gui/sprint_bar/noctilure_progress.png");

    @SubscribeEvent
    private static void onRenderGuiLayers(RenderGuiEvent.Post event) {
        GuiGraphics graphics = event.getGuiGraphics();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.getVehicle() != null) {
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            RenderSystem.enableBlend();
            Entity entity = minecraft.player.getVehicle();
            if (entity instanceof NoctilureEntity) {
                NoctilureEntity noctilure = (NoctilureEntity)entity;
                minecraft.getProfiler().push("energy");
                float energyNorm = (float)noctilure.getSprintEnergy() / 2000.0f;
                int progress = (int)((1.0f - energyNorm) * 182.0f);
                int barWidth = 182;
                int barHeight = 5;
                int y = screenHeight - 29;
                int x = screenWidth / 2 - barWidth / 2;
                RenderSystem.enableBlend();
                graphics.blit(SPRINT_BAR_BACKGROUND, x, y, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
                graphics.blit(SPRINT_BAR_PROGRESS, x, y, 0.0f, 0.0f, barWidth - progress, barHeight, barWidth, barHeight);
                RenderSystem.disableBlend();
                minecraft.getProfiler().pop();
            }
        }
    }
}

