/*
 * Decompiled with CFR 0.152.
 */
package wardentools.fluid;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import org.jetbrains.annotations.NotNull;

public class LiquidCorruptionFluid
extends BaseFlowingFluid {
    public LiquidCorruptionFluid(BaseFlowingFluid.Properties prop) {
        super(prop);
    }

    public boolean isSource(@NotNull FluidState state) {
        return false;
    }

    public int getAmount(FluidState state) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    @NotNull
    public Item getBucket() {
        return Items.AIR;
    }

    public static class Flowing
    extends LiquidCorruptionFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
            this.registerDefaultState((FluidState)((FluidState)this.getStateDefinition().any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }
    }

    public static class Source
    extends LiquidCorruptionFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        @Override
        public int getAmount(FluidState state) {
            return 8;
        }

        @Override
        public boolean isSource(@NotNull FluidState state) {
            return true;
        }
    }
}

