/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.RadianceCatalystBlockEntity;

public class RadianceCatalystItem
extends BlockItem {
    public RadianceCatalystItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        if (result.consumesAction()) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            ItemStack stack = context.getItemInHand();
            BlockItem.updateCustomBlockEntityTag((Level)level, (Player)context.getPlayer(), (BlockPos)pos, (ItemStack)stack);
            RadianceCatalystBlockEntity blockEntity = (RadianceCatalystBlockEntity)level.getBlockEntity(pos);
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (blockEntity == null) {
                return result;
            }
            if (data == null) {
                blockEntity.setEnergy(0);
                return result;
            }
            if (data.contains("Energy")) {
                blockEntity.setEnergy(data.copyTag().getInt("Energy"));
            } else {
                blockEntity.setEnergy(0);
            }
        }
        return result;
    }
}

