/*
 * Decompiled with CFR 0.152.
 */
package wardentools.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.items.ItemRegistry;
import wardentools.worldgen.structure.ModStructures;

public enum Crystal implements StringRepresentable
{
    AMETHYST(0, 9323254, () -> Blocks.AMETHYST_BLOCK, () -> Blocks.AMETHYST_CLUSTER, () -> Items.AMETHYST_SHARD, (Supplier<Item>)ItemRegistry.PENDANT_OF_BALANCE, ModStructures.AMETHYST_TEMPLE),
    RUBY(1, 15541541, (Supplier<Block>)BlockRegistry.RUBY_BLOCK, (Supplier<Block>)BlockRegistry.RUBY, (Supplier<Item>)ItemRegistry.RUBY_FRAGMENT, (Supplier<Item>)ItemRegistry.STRENGTH_BRACELET, ModStructures.RUBY_TEMPLE),
    CITRINE(2, 16761344, (Supplier<Block>)BlockRegistry.CITRINE_BLOCK, (Supplier<Block>)BlockRegistry.CITRINE, (Supplier<Item>)ItemRegistry.CITRINE_FRAGMENT, (Supplier<Item>)ItemRegistry.MIND_TIARA, ModStructures.CITRINE_TEMPLE),
    MALACHITE(3, 1093720, (Supplier<Block>)BlockRegistry.MALACHITE_BLOCK, (Supplier<Block>)BlockRegistry.MALACHITE, (Supplier<Item>)ItemRegistry.MALACHITE_FRAGMENT, (Supplier<Item>)ItemRegistry.RING_OF_WILL, ModStructures.MALACHITE_TEMPLE),
    ECHO(4, 2378601, (Supplier<Block>)BlockRegistry.ECHO_BLOCK, (Supplier<Block>)BlockRegistry.ECHO_CRISTAL, () -> Items.ECHO_SHARD, (Supplier<Item>)ItemRegistry.SHADOW_ORNAMENT, ModStructures.ECHO_TEMPLE),
    PALE(5, 1828075, (Supplier<Block>)BlockRegistry.PALE_CRISTAL_BLOCK, (Supplier<Block>)BlockRegistry.PALE_CRISTAL, (Supplier<Item>)ItemRegistry.PALE_SHARD, (Supplier<Item>)ItemRegistry.LIGHT_ORNAMENT, ModStructures.PALE_TEMPLE);

    private final int index;
    private final int color;
    private final Supplier<Block> crystalBlock;
    private final Supplier<Block> crystalBud;
    private final Supplier<Item> shard;
    private final Supplier<Item> jewel;
    private final ResourceKey<Structure> templeKey;

    private Crystal(int index, int color, Supplier<Block> block, Supplier<Block> bud, Supplier<Item> shard, Supplier<Item> jewel, ResourceKey<Structure> templeKey) {
        this.index = index;
        this.color = color;
        this.crystalBlock = block;
        this.crystalBud = bud;
        this.shard = shard;
        this.jewel = jewel;
        this.templeKey = templeKey;
    }

    public Block getCrystalBlock() {
        return this.crystalBlock.get();
    }

    public Block getCrystalBud() {
        return this.crystalBud.get();
    }

    public Item getShard() {
        return this.shard.get();
    }

    public Item getJewel() {
        return this.jewel.get();
    }

    public ResourceKey<Structure> getTempleKey() {
        return this.templeKey;
    }

    public int getIndex() {
        return this.index;
    }

    public int getColor() {
        return this.color;
    }

    public int getColorARGB() {
        return 0xFF000000 | this.color;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public static Crystal fromIndex(int index) {
        return LazyMaps.BY_INDEX.getOrDefault(index, Crystal.getDefault());
    }

    public static Crystal fromBlock(Block block) {
        return LazyMaps.BY_BLOCK.getOrDefault(block, Crystal.getDefault());
    }

    public static Crystal fromBud(Block bud) {
        return LazyMaps.BY_BUD.getOrDefault(bud, Crystal.getDefault());
    }

    public static Crystal fromItem(Item item) {
        return LazyMaps.BY_ITEM.getOrDefault(item, Crystal.getDefault());
    }

    public static Crystal fromJewel(Item item) {
        return LazyMaps.BY_JEWEL.getOrDefault(item, Crystal.getDefault());
    }

    public static Crystal fromName(String name) {
        return LazyMaps.BY_NAME.getOrDefault(name.toLowerCase(), Crystal.getDefault());
    }

    public static boolean isCrystalItem(Item item) {
        return LazyMaps.BY_ITEM.containsKey(item);
    }

    public static boolean isCrystalJewel(Item item) {
        return LazyMaps.BY_JEWEL.containsKey(item);
    }

    public static Crystal getDefault() {
        return AMETHYST;
    }

    public Crystal getNext() {
        return Crystal.fromIndex((this.index + 1) % Crystal.values().length);
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    private static class LazyMaps {
        private static final Map<Integer, Crystal> BY_INDEX = LazyMaps.buildIndexMap();
        private static final Map<Block, Crystal> BY_BLOCK = LazyMaps.buildBlockMap();
        private static final Map<Block, Crystal> BY_BUD = LazyMaps.buildBudMap();
        private static final Map<Item, Crystal> BY_ITEM = LazyMaps.buildItemMap();
        private static final Map<Item, Crystal> BY_JEWEL = LazyMaps.buildJewelMap();
        private static final Map<String, Crystal> BY_NAME = LazyMaps.buildNameMap();

        private LazyMaps() {
        }

        private static Map<Integer, Crystal> buildIndexMap() {
            HashMap<Integer, Crystal> map = new HashMap<Integer, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.index, c);
            }
            return map;
        }

        private static Map<Block, Crystal> buildBlockMap() {
            HashMap<Block, Crystal> map = new HashMap<Block, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.getCrystalBlock(), c);
            }
            return map;
        }

        private static Map<Block, Crystal> buildBudMap() {
            HashMap<Block, Crystal> map = new HashMap<Block, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.getCrystalBud(), c);
            }
            return map;
        }

        private static Map<Item, Crystal> buildItemMap() {
            HashMap<Item, Crystal> map = new HashMap<Item, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.getShard(), c);
            }
            return map;
        }

        private static Map<Item, Crystal> buildJewelMap() {
            HashMap<Item, Crystal> map = new HashMap<Item, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.getJewel(), c);
            }
            return map;
        }

        private static Map<String, Crystal> buildNameMap() {
            HashMap<String, Crystal> map = new HashMap<String, Crystal>();
            for (Crystal c : Crystal.values()) {
                map.put(c.getSerializedName(), c);
            }
            return map;
        }
    }
}

