/*
 * Decompiled with CFR 0.152.
 */
package wardentools.network;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import wardentools.advancement.ModCriteriaTriggers;
import wardentools.network.payloads.RequestStormStateFromServer;
import wardentools.network.payloads.SwitchAchievement;
import wardentools.network.payloads.TeleportPlayerTo;
import wardentools.network.payloads.datasync.SyncDataTaskToServer;
import wardentools.network.payloads.datasync.SyncKnownWhisperToServer;
import wardentools.playerdata.ModDataAttachments;
import wardentools.playerdata.serializables.CompletedTasks;
import wardentools.playerdata.serializables.KnownWindWhispers;
import wardentools.weather.AbyssWeatherEventServer;
import wardentools.worldgen.dimension.ModDimensions;
import wardentools.worldgen.portal.ModTeleporter;

public class ServerPayloadHandler {
    private static final ResourceLocation CORRUPTION_ADVANCEMENT = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"corruption_vessel");
    private static final ResourceLocation RADIANCE_ADVANCEMENT = ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"radiance_bringer");

    public static void teleportPlayerTo(TeleportPlayerTo msg, IPayloadContext ctx) {
        ServerPayloadHandler.handleDataOnNetwork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                Level level = serverPlayer.level();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                ServerPayloadHandler.teleport(serverLevel, (Entity)serverPlayer, (int)msg.respawnPos().x, (int)msg.respawnPos().y, (int)msg.respawnPos().z);
            }
        }, ctx);
    }

    public static void switchAchievement(SwitchAchievement msg, IPayloadContext ctx) {
        ServerPayloadHandler.handleDataOnNetwork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                if (msg.index() == 0) {
                    AdvancementHolder corruptionAdvancement = serverPlayer.server.getAdvancements().get(CORRUPTION_ADVANCEMENT);
                    if (corruptionAdvancement != null) {
                        for (String criterion : corruptionAdvancement.value().criteria().keySet()) {
                            serverPlayer.getAdvancements().revoke(corruptionAdvancement, criterion);
                        }
                    }
                    ModCriteriaTriggers.RADIANCE_BRINGER.trigger(serverPlayer);
                }
                if (msg.index() == 1) {
                    AdvancementHolder radianceAdvancement = serverPlayer.server.getAdvancements().get(RADIANCE_ADVANCEMENT);
                    if (radianceAdvancement != null) {
                        for (String criterion : radianceAdvancement.value().criteria().keySet()) {
                            serverPlayer.getAdvancements().revoke(radianceAdvancement, criterion);
                        }
                    }
                    ModCriteriaTriggers.CORRUPTION_VESSEL.trigger(serverPlayer);
                }
            }
        }, ctx);
    }

    public static void sendServerFogDistanceToPlayer(RequestStormStateFromServer msg, IPayloadContext ctx) {
        ServerPayloadHandler.handleDataOnNetwork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                AbyssWeatherEventServer.WEATHER_MANAGER.sendServerFogDistanceToClient(serverPlayer);
            }
        }, ctx);
    }

    public static void syncTaskData(SyncDataTaskToServer msg, IPayloadContext ctx) {
        ServerPayloadHandler.handleDataOnNetwork(() -> {
            CompletedTasks data = (CompletedTasks)ctx.player().getData(ModDataAttachments.COMPLETED_TASKS);
            if (msg.remove()) {
                data.removeCompletedTask(msg.taskId());
            } else {
                data.addCompletedTask(msg.taskId());
            }
            ctx.player().setData(ModDataAttachments.COMPLETED_TASKS, (Object)data);
        }, ctx);
    }

    public static void syncWindWhisperData(SyncKnownWhisperToServer msg, IPayloadContext ctx) {
        ServerPayloadHandler.handleDataOnNetwork(() -> {
            KnownWindWhispers data = (KnownWindWhispers)ctx.player().getData(ModDataAttachments.KNOWN_WIND_WHISPERS);
            if (msg.remove()) {
                data.removeKnownWhisper(msg.whisperId());
            } else {
                data.addKnownWhisper(msg.whisperId());
            }
            ctx.player().setData(ModDataAttachments.KNOWN_WIND_WHISPERS, (Object)data);
        }, ctx);
    }

    private static void teleport(ServerLevel level, Entity entity, int x, int y, int z) {
        ServerLevel overworldLevel;
        if (level.dimension() == Level.OVERWORLD) {
            ServerLevel abyssLevel = level.getServer().getLevel(ModDimensions.ABYSS_LEVEL_KEY);
            if (abyssLevel != null) {
                BlockPos ancientCityPos = new BlockPos(x, y, z);
                ServerPayloadHandler.teleportToDimension(entity, ModDimensions.ABYSS_LEVEL_KEY, ancientCityPos);
            }
        } else if (level.dimension() == ModDimensions.ABYSS_LEVEL_KEY && (overworldLevel = level.getServer().getLevel(Level.OVERWORLD)) != null) {
            BlockPos ancientCityPos = new BlockPos(x, y, z);
            ServerPayloadHandler.teleportToDimension(entity, (ResourceKey<Level>)Level.OVERWORLD, ancientCityPos);
        }
    }

    private static void teleportToDimension(Entity entity, ResourceKey<Level> targetDimension, BlockPos targetPos) {
        ServerLevel targetLevel = Objects.requireNonNull(entity.getServer()).getLevel(targetDimension);
        if (targetLevel == null) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.revive();
            serverPlayer.changeDimension(ModTeleporter.diveToAncientCity(targetLevel, targetPos, serverPlayer));
        } else if (!entity.level().isClientSide) {
            entity.changeDimension(ModTeleporter.diveToAncientCity(targetLevel, targetPos, entity));
        }
    }

    private static void handleDataOnNetwork(Runnable run, IPayloadContext ctx) {
        ctx.enqueueWork(run).exceptionally(e -> {
            LogUtils.getLogger().error("Dive Into the Abyss networking failed{}", (Object)e.getMessage());
            ctx.disconnect((Component)Component.literal((String)"Dive Into the Abyss networking failed"));
            return null;
        });
    }
}

