/*
 * Decompiled with CFR 0.152.
 */
package wardentools.particle;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wardentools.particle.options.GlyphParticleOptions;
import wardentools.particle.options.GlyphParticleRotatingOptions;
import wardentools.particle.options.ShineParticleOptions;

public class ParticleRegistry {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"wardentools");
    public static final Supplier<SimpleParticleType> ABYSS_AMBIENT = PARTICLE_TYPES.register("abyss_ambient", () -> new SimpleParticleType(true));
    public static final Supplier<SimpleParticleType> CORRUPTION = PARTICLE_TYPES.register("corruption", () -> new SimpleParticleType(true));
    public static final Supplier<SimpleParticleType> ABYSS_PORTAL = PARTICLE_TYPES.register("abyss_portal", () -> new SimpleParticleType(true));
    public static final Supplier<SimpleParticleType> RADIANCE = PARTICLE_TYPES.register("radiance", () -> new SimpleParticleType(true));
    public static final Supplier<SimpleParticleType> BLACK_CORRUPTION = PARTICLE_TYPES.register("black_corruption", () -> new SimpleParticleType(true));
    public static final Supplier<ParticleType<ShineParticleOptions>> SHINE_PARTICLE = ParticleRegistry.registerCustom("shine", ShineParticleOptions.CODEC, ShineParticleOptions.STREAM_CODEC);
    public static final Supplier<ParticleType<GlyphParticleOptions>> GLYPH_PARTICLE = ParticleRegistry.registerCustom("glyph", GlyphParticleOptions.CODEC, GlyphParticleOptions.STREAM_CODEC);
    public static final Supplier<ParticleType<GlyphParticleRotatingOptions>> GLYPH_PARTICLE_ROTATING = ParticleRegistry.registerCustom("glyph_rotating", GlyphParticleRotatingOptions.CODEC, GlyphParticleRotatingOptions.STREAM_CODEC);

    private static <T extends ParticleOptions> Supplier<ParticleType<T>> registerCustom(String name, final MapCodec<T> codec, final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        return PARTICLE_TYPES.register(name, () -> new ParticleType<T>(true){

            @NotNull
            public MapCodec<T> codec() {
                return codec;
            }

            @NotNull
            public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        });
    }
}

