/*
 * Decompiled with CFR 0.152.
 */
package wardentools.particle.options;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import wardentools.particle.ParticleRegistry;

public record GlyphParticleRotatingOptions(Vec3 center, Vec3 axis, double angularVelocity, int lifetime, int color, boolean emissive) implements ParticleOptions
{
    public static final MapCodec<GlyphParticleRotatingOptions> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.DOUBLE.fieldOf("x").forGetter(o -> o.center().x), (App)Codec.DOUBLE.fieldOf("y").forGetter(o -> o.center().y), (App)Codec.DOUBLE.fieldOf("z").forGetter(o -> o.center().z), (App)Codec.DOUBLE.fieldOf("x_axis").forGetter(o -> o.center().x), (App)Codec.DOUBLE.fieldOf("y_axis").forGetter(o -> o.center().y), (App)Codec.DOUBLE.fieldOf("z_axis").forGetter(o -> o.center().z), (App)Codec.DOUBLE.fieldOf("angular_velocity").forGetter(o -> o.angularVelocity), (App)Codec.INT.fieldOf("lifetime").forGetter(o -> o.lifetime), (App)Codec.INT.fieldOf("color").forGetter(o -> o.color), (App)Codec.BOOL.fieldOf("emissive").forGetter(o -> o.emissive)).apply((Applicative)inst, (x, y, z, xAxis, yAxis, zAxis, angularVelocity, lifetime, color, emissive) -> new GlyphParticleRotatingOptions(new Vec3(x.doubleValue(), y.doubleValue(), z.doubleValue()), new Vec3(xAxis.doubleValue(), yAxis.doubleValue(), zAxis.doubleValue()), (double)angularVelocity, (int)lifetime, (int)color, (boolean)emissive)));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlyphParticleRotatingOptions> STREAM_CODEC = StreamCodec.of((buf, o) -> {
        buf.writeDouble(o.center.x);
        buf.writeDouble(o.center.y);
        buf.writeDouble(o.center.z);
        buf.writeDouble(o.axis.x);
        buf.writeDouble(o.axis.y);
        buf.writeDouble(o.axis.z);
        buf.writeDouble(o.angularVelocity);
        buf.writeInt(o.lifetime);
        buf.writeInt(o.color);
        buf.writeBoolean(o.emissive);
    }, buf -> {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        double xAxis = buf.readDouble();
        double yAxis = buf.readDouble();
        double zAxis = buf.readDouble();
        double angularVelocity = buf.readDouble();
        int lifetime = buf.readInt();
        int color = buf.readInt();
        boolean emissive = buf.readBoolean();
        return new GlyphParticleRotatingOptions(new Vec3(x, y, z), new Vec3(xAxis, yAxis, zAxis), angularVelocity, lifetime, color, emissive);
    });

    public GlyphParticleRotatingOptions(Vec3 center, Vec3 axis, double angularVelocity, int color) {
        this(center, axis, angularVelocity, 120, color, true);
    }

    public static GlyphParticleRotatingOptions onXAxis(Vec3 center, double angularVelocity, int color) {
        return new GlyphParticleRotatingOptions(center, new Vec3(1.0, 0.0, 0.0), angularVelocity, color);
    }

    public static GlyphParticleRotatingOptions onYAxis(Vec3 center, double angularVelocity, int color) {
        return new GlyphParticleRotatingOptions(center, new Vec3(0.0, 1.0, 0.0), angularVelocity, color);
    }

    public static GlyphParticleRotatingOptions onZAxis(Vec3 center, double angularVelocity, int color) {
        return new GlyphParticleRotatingOptions(center, new Vec3(0.0, 0.0, 1.0), angularVelocity, color);
    }

    @NotNull
    public ParticleType<?> getType() {
        return ParticleRegistry.GLYPH_PARTICLE_ROTATING.get();
    }
}

