/*
 * Decompiled with CFR 0.152.
 */
package wardentools.playerdata;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import wardentools.network.payloads.datasync.SyncDataTaskToClient;
import wardentools.network.payloads.datasync.SyncKnownWhisperToClient;
import wardentools.playerdata.ModDataAttachments;
import wardentools.playerdata.serializables.CompletedTasks;
import wardentools.playerdata.serializables.KnownWindWhispers;

@EventBusSubscriber(modid="wardentools")
public class AttachCapabilities {
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasData(ModDataAttachments.COMPLETED_TASKS)) {
            ((CompletedTasks)event.getEntity().getData(ModDataAttachments.COMPLETED_TASKS)).copy((CompletedTasks)event.getOriginal().getData(ModDataAttachments.COMPLETED_TASKS));
        }
        if (event.isWasDeath() && event.getOriginal().hasData(ModDataAttachments.KNOWN_WIND_WHISPERS)) {
            ((KnownWindWhispers)event.getEntity().getData(ModDataAttachments.KNOWN_WIND_WHISPERS)).copy((KnownWindWhispers)event.getOriginal().getData(ModDataAttachments.KNOWN_WIND_WHISPERS));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompletedTasks taskData = (CompletedTasks)player2.getData(ModDataAttachments.COMPLETED_TASKS);
            for (int taskId : taskData.getAll()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncDataTaskToClient(taskId, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            KnownWindWhispers whisperData = (KnownWindWhispers)player2.getData(ModDataAttachments.KNOWN_WIND_WHISPERS);
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncKnownWhisperToClient(whisperData.getAllAsArray()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

