/*
 * Decompiled with CFR 0.152.
 */
package wardentools.weather;

import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import wardentools.weather.AbyssWeatherManager;
import wardentools.worldgen.dimension.ModDimensions;

@EventBusSubscriber(modid="wardentools")
public class AbyssWeatherEventServer {
    public static final AbyssWeatherManager WEATHER_MANAGER = new AbyssWeatherManager();

    @SubscribeEvent
    public static void onServerTickEvent(ServerTickEvent.Pre event) {
        ServerLevel abyssLevel = event.getServer().getLevel(ModDimensions.ABYSS_LEVEL_KEY);
        if (abyssLevel == null) {
            return;
        }
        WEATHER_MANAGER.tick(abyssLevel);
    }

    @SubscribeEvent
    public static void onWeatherCommand(CommandEvent event) {
        CommandContextBuilder context = event.getParseResults().getContext();
        if (context.getNodes().isEmpty()) {
            return;
        }
        String command = ((ParsedCommandNode)context.getNodes().getFirst()).getNode().getName();
        if (command.equals("weather")) {
            AbyssWeatherEventServer.handleWeatherCommand(context, ((CommandSourceStack)event.getParseResults().getContext().getSource()).getLevel());
        }
    }

    private static void handleWeatherCommand(CommandContextBuilder<?> context, ServerLevel level) {
        if (level.dimension() != ModDimensions.ABYSS_LEVEL_KEY) {
            return;
        }
        List nodes = context.getNodes();
        if (nodes.size() < 2) {
            return;
        }
        String subCommand = ((ParsedCommandNode)nodes.get(1)).getNode().getName();
        int duration = AbyssWeatherEventServer.parseDuration(context);
        if (duration == 0) {
            switch (subCommand) {
                case "clear": {
                    WEATHER_MANAGER.weatherClear(level);
                    break;
                }
                case "rain": 
                case "thunder": {
                    WEATHER_MANAGER.startNewEvent(level);
                    break;
                }
            }
        } else {
            switch (subCommand) {
                case "clear": {
                    WEATHER_MANAGER.weatherClear(level, duration);
                    break;
                }
                case "rain": 
                case "thunder": {
                    WEATHER_MANAGER.startNewEvent(level, duration);
                    break;
                }
            }
        }
    }

    private static int parseDuration(CommandContextBuilder<?> context) {
        try {
            ParsedArgument durationArg = (ParsedArgument)context.getArguments().get("duration");
            if (durationArg != null) {
                return (Integer)durationArg.getResult();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

