/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import wardentools.worldgen.biome.surface.ModSurfaceRules;

public class CustomNoiseSettings {
    private static final ResourceKey<DensityFunction> Y = CustomNoiseSettings.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = CustomNoiseSettings.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = CustomNoiseSettings.createKey("shift_z");
    public static final ResourceKey<DensityFunction> CONTINENTS = CustomNoiseSettings.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = CustomNoiseSettings.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = CustomNoiseSettings.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> FACTOR = CustomNoiseSettings.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> DEPTH = CustomNoiseSettings.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = CustomNoiseSettings.createKey("overworld/sloped_cheese");
    public static final ResourceKey<DensityFunction> CONTINENTS_LARGE = CustomNoiseSettings.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION_LARGE = CustomNoiseSettings.createKey("overworld/erosion");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = CustomNoiseSettings.createKey("overworld/factor");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = CustomNoiseSettings.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = CustomNoiseSettings.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> FACTOR_AMPLIFIED = CustomNoiseSettings.createKey("overworld/factor");
    private static final ResourceKey<DensityFunction> DEPTH_AMPLIFIED = CustomNoiseSettings.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_AMPLIFIED = CustomNoiseSettings.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = CustomNoiseSettings.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = CustomNoiseSettings.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = CustomNoiseSettings.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = CustomNoiseSettings.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = CustomNoiseSettings.createKey("overworld/caves/spaghetti_2d");
    public static final Codec<NoiseGeneratorSettings> DIRECT_CODEC = RecordCodecBuilder.create(p_64475_ -> p_64475_.group((App)NoiseSettings.CODEC.fieldOf("noise").forGetter(NoiseGeneratorSettings::noiseSettings), (App)BlockState.CODEC.fieldOf("default_block").forGetter(NoiseGeneratorSettings::defaultBlock), (App)BlockState.CODEC.fieldOf("default_fluid").forGetter(NoiseGeneratorSettings::defaultFluid), (App)NoiseRouter.CODEC.fieldOf("noise_router").forGetter(NoiseGeneratorSettings::noiseRouter), (App)SurfaceRules.RuleSource.CODEC.fieldOf("surface_rule").forGetter(NoiseGeneratorSettings::surfaceRule), (App)Climate.ParameterPoint.CODEC.listOf().fieldOf("spawn_target").forGetter(NoiseGeneratorSettings::spawnTarget), (App)Codec.INT.fieldOf("sea_level").forGetter(NoiseGeneratorSettings::seaLevel), (App)Codec.BOOL.fieldOf("disable_mob_generation").forGetter(NoiseGeneratorSettings::disableMobGeneration), (App)Codec.BOOL.fieldOf("aquifers_enabled").forGetter(NoiseGeneratorSettings::isAquifersEnabled), (App)Codec.BOOL.fieldOf("ore_veins_enabled").forGetter(NoiseGeneratorSettings::oreVeinsEnabled), (App)Codec.BOOL.fieldOf("legacy_random_source").forGetter(NoiseGeneratorSettings::useLegacyRandomSource)).apply((Applicative)p_64475_, NoiseGeneratorSettings::new));
    public static final Codec<Holder<NoiseGeneratorSettings>> CODEC = RegistryFileCodec.create((ResourceKey)Registries.NOISE_SETTINGS, DIRECT_CODEC);
    public static final ResourceKey<NoiseGeneratorSettings> ABYSS_NOISE = CustomNoiseSettings.createNoiseKey("abyss_noise");

    private static ResourceKey<NoiseGeneratorSettings> createNoiseKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)name));
    }

    private static ResourceKey<DensityFunction> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)name));
    }

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> ctx) {
        ctx.register(ABYSS_NOISE, (Object)CustomNoiseSettings.createAbyssNoiseSettings(ctx, false, false));
    }

    private static NoiseGeneratorSettings createAbyssNoiseSettings(BootstrapContext<?> context, boolean amplified, boolean large) {
        return new NoiseGeneratorSettings(NoiseSettings.create((int)-64, (int)384, (int)1, (int)2), Blocks.STONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), CustomNoiseSettings.overworld((HolderGetter<DensityFunction>)context.lookup(Registries.DENSITY_FUNCTION), (HolderGetter<NormalNoise.NoiseParameters>)context.lookup(Registries.NOISE), large, amplified), ModSurfaceRules.makeRules(), new OverworldBiomeBuilder().spawnTarget(), 63, false, false, true, false);
    }

    protected static NoiseRouter overworld(HolderGetter<DensityFunction> densityFunctionRegistry, HolderGetter<NormalNoise.NoiseParameters> noiseParameterRegistry, boolean isLarge, boolean isAmplified) {
        DensityFunction aquiferBarrierNoise = DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.5);
        DensityFunction aquiferFloodednessNoise = DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), (double)0.3);
        DensityFunction aquiferSpreadNoise = DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.5);
        DensityFunction aquiferLavaNoise = DensityFunctions.constant((double)0.0);
        DensityFunction shiftX = CustomNoiseSettings.getFunction(densityFunctionRegistry, SHIFT_X);
        DensityFunction shiftZ = CustomNoiseSettings.getFunction(densityFunctionRegistry, SHIFT_Z);
        DensityFunction temperatureNoise = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noiseParameterRegistry.getOrThrow(isLarge ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE));
        DensityFunction vegetationNoise = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noiseParameterRegistry.getOrThrow(isLarge ? Noises.VEGETATION_LARGE : Noises.VEGETATION));
        DensityFunction factor = CustomNoiseSettings.getFunction(densityFunctionRegistry, isLarge ? FACTOR_LARGE : (isAmplified ? FACTOR_AMPLIFIED : FACTOR));
        DensityFunction depth = CustomNoiseSettings.getFunction(densityFunctionRegistry, isLarge ? DEPTH_LARGE : (isAmplified ? DEPTH_AMPLIFIED : DEPTH));
        DensityFunction gradientDensity = CustomNoiseSettings.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)factor), depth);
        DensityFunction slopedCheese = CustomNoiseSettings.getFunction(densityFunctionRegistry, isLarge ? SLOPED_CHEESE_LARGE : (isAmplified ? SLOPED_CHEESE_AMPLIFIED : SLOPED_CHEESE));
        DensityFunction entrances = CustomNoiseSettings.getFunction(densityFunctionRegistry, ENTRANCES);
        DensityFunction minSlopedCheeseEntrances = DensityFunctions.min((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)entrances));
        DensityFunction undergroundNoise = CustomNoiseSettings.underground(densityFunctionRegistry, noiseParameterRegistry, slopedCheese);
        DensityFunction rangeChoice = DensityFunctions.rangeChoice((DensityFunction)slopedCheese, (double)-1000000.0, (double)1.5625, (DensityFunction)minSlopedCheeseEntrances, (DensityFunction)undergroundNoise);
        DensityFunction postProcessed = DensityFunctions.min((DensityFunction)CustomNoiseSettings.postProcess(CustomNoiseSettings.slideOverworld(isAmplified, rangeChoice)), (DensityFunction)CustomNoiseSettings.getFunction(densityFunctionRegistry, NOODLE));
        DensityFunction yFunction = CustomNoiseSettings.getFunction(densityFunctionRegistry, Y);
        int minVeinY = Stream.of(VeinType.values()).mapToInt(vein -> vein.minY).min().orElse(-DimensionType.MIN_Y * 2);
        int maxVeinY = Stream.of(VeinType.values()).mapToInt(vein -> vein.maxY).max().orElse(-DimensionType.MIN_Y * 2);
        DensityFunction oreVeininess = CustomNoiseSettings.yLimitedInterpolatable(yFunction, DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.ORE_VEININESS), (double)1.5, (double)1.5), minVeinY, maxVeinY, 0);
        DensityFunction oreVeinA = CustomNoiseSettings.yLimitedInterpolatable(yFunction, DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.ORE_VEIN_A), (double)4.0, (double)4.0), minVeinY, maxVeinY, 0).abs();
        DensityFunction oreVeinB = CustomNoiseSettings.yLimitedInterpolatable(yFunction, DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.ORE_VEIN_B), (double)4.0, (double)4.0), minVeinY, maxVeinY, 0).abs();
        DensityFunction oreVeinCombined = DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.08f), (DensityFunction)DensityFunctions.max((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction oreGap = DensityFunctions.noise((Holder)noiseParameterRegistry.getOrThrow(Noises.ORE_GAP));
        return new NoiseRouter(aquiferBarrierNoise, aquiferFloodednessNoise, aquiferSpreadNoise, aquiferLavaNoise, temperatureNoise, vegetationNoise, CustomNoiseSettings.getFunction(densityFunctionRegistry, isLarge ? CONTINENTS_LARGE : CONTINENTS), CustomNoiseSettings.getFunction(densityFunctionRegistry, isLarge ? EROSION_LARGE : EROSION), depth, CustomNoiseSettings.getFunction(densityFunctionRegistry, RIDGES), CustomNoiseSettings.slideOverworld(isAmplified, DensityFunctions.add((DensityFunction)gradientDensity, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-64.0, 64.0)), postProcessed, oreVeininess, oreVeinCombined, oreGap);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> p_256312_, ResourceKey<DensityFunction> p_256077_) {
        return new DensityFunctions.HolderHolder((Holder)p_256312_.getOrThrow(p_256077_));
    }

    private static DensityFunction underground(HolderGetter<DensityFunction> densFuncHold, HolderGetter<NormalNoise.NoiseParameters> noiseParam, DensityFunction densFunc) {
        DensityFunction densityfunction = CustomNoiseSettings.getFunction(densFuncHold, SPAGHETTI_2D);
        DensityFunction densityfunction1 = CustomNoiseSettings.getFunction(densFuncHold, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.noise((Holder)noiseParam.getOrThrow(Noises.CAVE_LAYER), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)densityfunction2.square());
        DensityFunction densityfunction4 = DensityFunctions.noise((Holder)noiseParam.getOrThrow(Noises.CAVE_CHEESE), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.add((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.27), (DensityFunction)densityfunction4).clamp(-1.0, 1.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)1.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.64), (DensityFunction)densFunc)).clamp(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.add((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.min((DensityFunction)DensityFunctions.min((DensityFunction)densityfunction6, (DensityFunction)CustomNoiseSettings.getFunction(densFuncHold, ENTRANCES)), (DensityFunction)DensityFunctions.add((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = CustomNoiseSettings.getFunction(densFuncHold, PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.rangeChoice((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.constant((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.max((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }

    private static DensityFunction postProcess(DensityFunction densFunc) {
        DensityFunction densityfunction = DensityFunctions.blendDensity((DensityFunction)densFunc);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.interpolated((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.constant((double)0.64)).squeeze();
    }

    private static DensityFunction noiseGradientDensity(DensityFunction densFunc1, DensityFunction densFunc2) {
        DensityFunction densityfunction = DensityFunctions.mul((DensityFunction)densFunc2, (DensityFunction)densFunc1);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)densityfunction.quarterNegative());
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.interpolated((DensityFunction)DensityFunctions.rangeChoice((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.constant((double)p_209476_)));
    }

    private static DensityFunction slideOverworld(boolean amplified, DensityFunction densFunc) {
        return CustomNoiseSettings.slide(densFunc, -64, 384, amplified ? 16 : 80, amplified ? 0 : 64, -0.078125, 0, 24, amplified ? 0.4 : 0.1171875);
    }

    private static DensityFunction slide(DensityFunction densFunc, int y_floor, int y_roof, int i1, int i2, double d1, int i3, int i4, double d2) {
        DensityFunction densityfunction1 = DensityFunctions.yClampedGradient((int)(y_floor + y_roof - i1), (int)(y_floor + y_roof - i2), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.lerp((DensityFunction)densityfunction1, (double)d1, (DensityFunction)densFunc);
        DensityFunction densityfunction2 = DensityFunctions.yClampedGradient((int)(y_floor + i3), (int)(y_floor + i4), (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)densityfunction2, (double)d2, (DensityFunction)$$9);
    }

    protected static enum VeinType {
        IRON(Blocks.DEEPSLATE_IRON_ORE.defaultBlockState(), Blocks.RAW_IRON_BLOCK.defaultBlockState(), Blocks.TUFF.defaultBlockState(), -60, -8);

        final BlockState ore;
        final BlockState rawOreBlock;
        final BlockState filler;
        protected final int minY;
        protected final int maxY;

        private VeinType(BlockState p_209684_, BlockState p_209685_, BlockState p_209686_, int p_209687_, int p_209688_) {
            this.ore = p_209684_;
            this.rawOreBlock = p_209685_;
            this.filler = p_209686_;
            this.minY = p_209687_;
            this.maxY = p_209688_;
        }
    }
}

