/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.biome.surface;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import wardentools.block.BlockRegistry;
import wardentools.worldgen.biome.ModBiomes;

public class ModSurfaceRules {
    private static final SurfaceRules.RuleSource DARKDIRT = ModSurfaceRules.makeStateRule((Block)BlockRegistry.DARKDIRT.get());
    private static final SurfaceRules.RuleSource DARKGRASS = ModSurfaceRules.makeStateRule((Block)BlockRegistry.DARKGRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource DEEPSLATE = ModSurfaceRules.makeStateRule(Blocks.DEEPSLATE);
    private static final SurfaceRules.RuleSource ABYSSALITE = ModSurfaceRules.makeStateRule((Block)BlockRegistry.ABYSSALITE.get());
    private static final SurfaceRules.RuleSource BEDROCK = ModSurfaceRules.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource CORRUPTED_ABYSSALITE = ModSurfaceRules.makeStateRule((Block)BlockRegistry.CORRUPTED_ABYSSALITE.get());
    private static final SurfaceRules.RuleSource DIRT = ModSurfaceRules.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = ModSurfaceRules.makeStateRule(Blocks.GRASS_BLOCK);

    public static SurfaceRules.RuleSource makeRules() {
        SurfaceRules.ConditionSource isAtOrAboveWaterLevel = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.RuleSource defaultOverWorld = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)GRASS_BLOCK)), DIRT});
        SurfaceRules.RuleSource bedrock_floor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"minecraft:bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK);
        SurfaceRules.RuleSource darkgrassSurface = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)DARKGRASS)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)DARKDIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)DARKDIRT)}));
        SurfaceRules.RuleSource abyssaliteUnderground = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.aboveBottom((int)56), (int)0)), (SurfaceRules.RuleSource)ABYSSALITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"wardentools:abyssalite", (VerticalAnchor)VerticalAnchor.aboveBottom((int)56), (VerticalAnchor)VerticalAnchor.aboveBottom((int)64)), (SurfaceRules.RuleSource)ABYSSALITE)});
        SurfaceRules.RuleSource abyssSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrock_floor, darkgrassSurface, abyssaliteUnderground, DEEPSLATE});
        SurfaceRules.RuleSource wasteLandSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrock_floor, abyssaliteUnderground, DEEPSLATE});
        SurfaceRules.RuleSource corruptedAbyssaliteCaves = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)CORRUPTED_ABYSSALITE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)CORRUPTED_ABYSSALITE)});
        SurfaceRules.RuleSource blindingDepthSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrock_floor, corruptedAbyssaliteCaves, abyssaliteUnderground, DEEPSLATE});
        SurfaceRules.RuleSource abyssGeneration = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.DEEP_FOREST}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.WASTE_LAND}), (SurfaceRules.RuleSource)wasteLandSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.WHITE_FOREST}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.CRYSTAL_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.BLINDING_DEPTH}), (SurfaceRules.RuleSource)blindingDepthSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.AMETHYST_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.CITRINE_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.MALACHITE_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.RUBY_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.ECHO_CAVE}), (SurfaceRules.RuleSource)abyssSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.PALE_CAVE}), (SurfaceRules.RuleSource)abyssSurface)});
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{abyssGeneration, defaultOverWorld});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }
}

