/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.dimension;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import wardentools.worldgen.CustomNoiseSettings;
import wardentools.worldgen.biome.ModBiomes;

public class ModDimensions {
    public static final float ABYSS_AMBIENT_LIGHT = 0.01f;
    public static final float CRYSTAL_BIOMES_DEPTH = 0.7f;
    public static final ResourceKey<LevelStem> ABYSS_KEY = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"abyssdim"));
    public static final ResourceKey<Level> ABYSS_LEVEL_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"abyssdim"));
    public static final ResourceKey<DimensionType> ABYSS_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"abyssdim_type"));

    public static void bootstrapType(BootstrapContext<DimensionType> context) {
        context.register(ABYSS_DIM_TYPE, (Object)new DimensionType(OptionalLong.of(1000L), false, false, false, false, 1.0, false, false, -64, 384, 384, BlockTags.INFINIBURN_OVERWORLD, BuiltinDimensionTypes.NETHER_EFFECTS, 0.01f, new DimensionType.MonsterSettings(false, false, (IntProvider)ConstantInt.of((int)0), 0)));
    }

    public static void bootstrapStem(BootstrapContext<LevelStem> context) {
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        HolderGetter dimTypes = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseGenSettings = context.lookup(Registries.NOISE_SETTINGS);
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromList(ModDimensions.biomes((HolderGetter<Biome>)biomeRegistry)), (Holder)noiseGenSettings.getOrThrow(CustomNoiseSettings.ABYSS_NOISE));
        LevelStem stem = new LevelStem((Holder)dimTypes.getOrThrow(ABYSS_DIM_TYPE), (ChunkGenerator)chunkGenerator);
        context.register(ABYSS_KEY, (Object)stem);
    }

    public static Climate.ParameterList<Holder<Biome>> biomes(HolderGetter<Biome> biomeRegistry) {
        return new Climate.ParameterList(List.of(ModDimensions.climate(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ModBiomes.DEEP_FOREST, biomeRegistry), ModDimensions.climate(0.6f, -0.4f, 0.0f, 0.5f, 0.0f, 0.0f, ModBiomes.WASTE_LAND, biomeRegistry), ModDimensions.climate(-0.6f, 0.4f, -0.5f, -0.5f, 0.0f, 0.0f, ModBiomes.WHITE_FOREST, biomeRegistry), ModDimensions.climate(0.0f, 0.5f, 0.6f, 0.1f, 0.8f, 0.3f, ModBiomes.CRYSTAL_CAVE, biomeRegistry), ModDimensions.climate(0.0f, 0.0f, 0.5f, 0.0f, 0.9f, 0.0f, ModBiomes.BLINDING_DEPTH, biomeRegistry), ModDimensions.climate(-0.1f, -0.6f, 0.0f, 0.1f, 0.7f, 0.2f, ModBiomes.AMETHYST_CAVE, biomeRegistry), ModDimensions.climate(0.5f, -0.1f, 0.0f, 0.1f, 0.7f, 0.2f, ModBiomes.CITRINE_CAVE, biomeRegistry), ModDimensions.climate(0.1f, 0.5f, 0.0f, 0.1f, 0.7f, 0.2f, ModBiomes.MALACHITE_CAVE, biomeRegistry), ModDimensions.climate(0.4f, -0.5f, 0.0f, 0.1f, 0.7f, 0.2f, ModBiomes.RUBY_CAVE, biomeRegistry), ModDimensions.climate(-0.5f, 0.3f, 0.0f, 0.1f, 0.7f, 0.1f, ModBiomes.ECHO_CAVE, biomeRegistry), ModDimensions.climate(-0.8f, 0.2f, 0.0f, 0.1f, 0.7f, 0.4f, ModBiomes.PALE_CAVE, biomeRegistry)));
    }

    public static Pair<Climate.ParameterPoint, Holder<Biome>> climate(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, ResourceKey<Biome> biomeKey, HolderGetter<Biome> biomeRegistry) {
        return Pair.of((Object)Climate.parameters((float)temperature, (float)humidity, (float)continentalness, (float)erosion, (float)depth, (float)weirdness, (float)0.0f), (Object)biomeRegistry.getOrThrow(biomeKey));
    }
}

