/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import wardentools.block.BlockRegistry;
import wardentools.block.depthvines.DepthVines;
import wardentools.worldgen.features.custom.DepthVineConfiguration;

public class DepthVineFeature
extends Feature<DepthVineConfiguration> {
    private static final int MAX_REACH = 150;
    private static final float CHANCE_BERRY_ON_PLACEMENT = 0.11f;

    public DepthVineFeature(Codec<DepthVineConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DepthVineConfiguration> context) {
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        DepthVineConfiguration config = (DepthVineConfiguration)context.config();
        for (int k = 0; !level.getBlockState(origin).isAir() && k < 150; ++k) {
            origin = origin.above();
        }
        BlockPos pos = origin.above();
        for (int i = 0; level.getBlockState(pos).isAir() && i < 150; ++i) {
            pos = pos.above();
        }
        if (DepthVines.canHangBelow(level.getBlockState(pos), (LevelReader)level, pos)) {
            int length;
            if (config.adaptative()) {
                int totalSpace = pos.getY() - origin.getY() + DepthVineFeature.availableSpaceBelow(level, origin, 150);
                length = DepthVineFeature.nextTriangular(context.random(), (int)((float)totalSpace * 0.2f), (int)((float)totalSpace * 0.85f), (int)((float)totalSpace * 0.55f));
            } else {
                length = DepthVineFeature.nextTriangular(context.random(), config.min(), config.max(), config.averageLength());
            }
            BlockPos placePos = pos.below();
            for (int j = 0; j < length && level.getBlockState(placePos).isAir(); ++j) {
                boolean hasBerries = context.random().nextFloat() < 0.11f;
                level.setBlock(placePos, (BlockState)((Block)BlockRegistry.DEPTH_VINES.get()).defaultBlockState().setValue((Property)DepthVines.BERRIES, (Comparable)Boolean.valueOf(hasBerries)), 3);
                placePos = placePos.below();
            }
            return true;
        }
        return false;
    }

    public static int availableSpaceBelow(WorldGenLevel level, BlockPos pos, int max) {
        int space;
        for (space = 0; level.getBlockState(pos).isAir() && space < max; ++space) {
            pos = pos.below();
        }
        return space;
    }

    public static int nextTriangular(RandomSource random, double min, double max, double mode) {
        double c;
        double u = random.nextDouble();
        if (u < (c = (mode - min) / (max - min))) {
            return Math.round(Math.round(min + Math.sqrt(u * (max - min) * (mode - min))));
        }
        return Math.round(Math.round(max - Math.sqrt((1.0 - u) * (max - min) * (max - mode))));
    }
}

