/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import org.jetbrains.annotations.NotNull;

public class DoublePlantFeature
extends Feature<SimpleBlockConfiguration> {
    public DoublePlantFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<SimpleBlockConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        BlockState state = ((SimpleBlockConfiguration)context.config()).toPlace().getState(context.random(), origin);
        if (!state.canSurvive((LevelReader)level, origin)) {
            return false;
        }
        if (level.getBlockState(origin.below()).is(Blocks.SCULK) && context.random().nextInt(0, 7) >= 5) {
            return false;
        }
        level.setBlock(origin, state, 2);
        if (state.hasProperty((Property)DoublePlantBlock.HALF)) {
            BlockState aboveState = (BlockState)state.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
            level.setBlock(origin.above(), aboveState, 2);
            level.scheduleTick(origin.above(), state.getBlock(), 5);
        }
        return true;
    }
}

