/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;

public class PlaceAbyssPortal
extends Feature<NoneFeatureConfiguration> {
    public static final Block FRAME_BLOCK = Blocks.REINFORCED_DEEPSLATE;
    public static final Block PORTAL_BLOCK = (Block)BlockRegistry.ABYSS_PORTAL_BLOCK.get();
    public static final int MAX_LENGTH = 30;
    public static final int MAX_HEIGHT = 20;
    private final List<BlockPos> toPlace = new ArrayList<BlockPos>();

    public PlaceAbyssPortal(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        if (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().below())) {
            return false;
        }
        int i = 0;
        Direction direction = this.getPortalOrientation(ctx);
        while (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(0, i, 0))) {
            if (i > 20) {
                return false;
            }
            if (!this.placeLine(ctx, i, direction, i == 0 || PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(0, i + 1, 0)))) {
                return false;
            }
            ++i;
        }
        if (!PlaceAbyssPortal.checkCorrectFrame(this.toPlace)) {
            return false;
        }
        this.createPortal(ctx);
        return true;
    }

    private Direction getPortalOrientation(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        if (PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(-1, -1, 0)) || PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(1, -1, 0))) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    private boolean placeLine(FeaturePlaceContext<NoneFeatureConfiguration> ctx, int verticalOffset, Direction direction, boolean firstLine) {
        if (direction == Direction.NORTH) {
            int i = 1;
            while (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(i, verticalOffset, 0))) {
                if (i > 30) {
                    return false;
                }
                if (firstLine && !PlaceAbyssPortal.hasFrameUnderOrAbove(ctx, ctx.origin().offset(i, verticalOffset, 0))) {
                    return false;
                }
                this.savePortalPos(ctx.origin().offset(i, verticalOffset, 0));
                ++i;
            }
            i = 0;
            while (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(i, verticalOffset, 0))) {
                if (i < -30) {
                    return false;
                }
                if (firstLine && !PlaceAbyssPortal.hasFrameUnderOrAbove(ctx, ctx.origin().offset(i, verticalOffset, 0))) {
                    return false;
                }
                this.savePortalPos(ctx.origin().offset(i, verticalOffset, 0));
                --i;
            }
        } else {
            int i = 1;
            while (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(0, verticalOffset, i))) {
                if (i >= 30) {
                    return false;
                }
                if (firstLine && !PlaceAbyssPortal.hasFrameUnderOrAbove(ctx, ctx.origin().offset(0, verticalOffset, i))) {
                    return false;
                }
                this.savePortalPos(ctx.origin().offset(0, verticalOffset, i));
                ++i;
            }
            i = 0;
            while (!PlaceAbyssPortal.isFrame(ctx, ctx.origin().offset(0, verticalOffset, i))) {
                if (i < -30) {
                    return false;
                }
                if (firstLine && !PlaceAbyssPortal.hasFrameUnderOrAbove(ctx, ctx.origin().offset(0, verticalOffset, i))) {
                    return false;
                }
                this.savePortalPos(ctx.origin().offset(0, verticalOffset, i));
                --i;
            }
        }
        return true;
    }

    private static boolean isFrame(FeaturePlaceContext<NoneFeatureConfiguration> ctx, BlockPos pos) {
        return ctx.level().getBlockState(pos).is(FRAME_BLOCK);
    }

    private void savePortalPos(BlockPos pos) {
        this.toPlace.add(pos);
    }

    private void createPortal(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        for (BlockPos pos : this.toPlace) {
            ctx.level().setBlock(pos, PORTAL_BLOCK.defaultBlockState(), 3);
        }
    }

    private static boolean checkCorrectFrame(List<BlockPos> pos) {
        int minX = pos.stream().mapToInt(Vec3i::getX).min().orElse(0);
        int maxX = pos.stream().mapToInt(Vec3i::getX).max().orElse(0);
        int minY = pos.stream().mapToInt(Vec3i::getY).min().orElse(0);
        int maxY = pos.stream().mapToInt(Vec3i::getY).max().orElse(0);
        int minZ = pos.stream().mapToInt(Vec3i::getZ).min().orElse(0);
        int maxZ = pos.stream().mapToInt(Vec3i::getZ).max().orElse(0);
        return pos.size() == (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
    }

    private static boolean hasFrameUnderOrAbove(FeaturePlaceContext<NoneFeatureConfiguration> ctx, BlockPos pos) {
        return PlaceAbyssPortal.isFrame(ctx, pos.above()) || PlaceAbyssPortal.isFrame(ctx, pos.below());
    }
}

