/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom.sculk;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.slf4j.Logger;
import wardentools.block.sculktendril.TendrilTree;
import wardentools.worldgen.features.custom.sculk.SculkTendrilsEmergenceConfiguration;
import wardentools.worldgen.features.custom.sculk.TendrilTreeUtils;

public class SculkTendrilsEmergence
extends Feature<SculkTendrilsEmergenceConfiguration> {
    private static final int MAX_TOTAL_NODES = 1000;
    private static final float MIN_BRANCH_PROBABILITY = 0.01f;
    private static final Logger LOGGER = LogUtils.getLogger();

    public SculkTendrilsEmergence(Codec<SculkTendrilsEmergenceConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SculkTendrilsEmergenceConfiguration> context) {
        WorldGenLevel level = context.level();
        boolean upward = ((SculkTendrilsEmergenceConfiguration)context.config()).upward();
        float deviationStrength = Math.min(1.0f, Math.max(0.001f, ((SculkTendrilsEmergenceConfiguration)context.config()).deviationStrength()));
        int maxDepth = Math.max(0, Math.min(10, ((SculkTendrilsEmergenceConfiguration)context.config()).maxDepth()));
        float heightReductionFactor = Math.max(0.1f, Math.min(0.9f, ((SculkTendrilsEmergenceConfiguration)context.config()).heightReductionFactor()));
        float branchProbability = Math.max(0.01f, Math.min(0.8f, ((SculkTendrilsEmergenceConfiguration)context.config()).branchProbability()));
        int maxLength = Math.max(1, Math.min(20, ((SculkTendrilsEmergenceConfiguration)context.config()).maxLength()));
        TendrilTree tree = new TendrilTree(context.origin());
        this.setBlock((LevelWriter)level, upward ? context.origin().below() : context.origin().above(), Blocks.SCULK.defaultBlockState());
        this.recursiveTreeStructure(tree, context.origin(), deviationStrength, 0, maxDepth, maxLength, heightReductionFactor, branchProbability, level.getRandom(), Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom()), upward);
        if (tree.getAllNodes().size() > 1000) {
            return false;
        }
        TendrilTreeUtils.placeBlocksWithoutUpdate(level, tree, context.origin());
        TendrilTreeUtils.configureBlockEntities(level, tree, context.origin());
        tree.updateAllNodes(level);
        return true;
    }

    private void recursiveTreeStructure(TendrilTree tree, BlockPos origin, float deviationStrength, int depth, int maxDepth, int maxLength, float heightReductionFactor, float branchProbability, RandomSource random, Direction directionToPrevious, boolean upward) {
        if (depth > maxDepth) {
            return;
        }
        int currentMaxLength = Math.max(1, (int)((float)maxLength * heightReductionFactor));
        float currentBranchingProbability = Math.max(0.01f, branchProbability * heightReductionFactor);
        ArrayList<Direction> currentBranch = new ArrayList<Direction>();
        int length = random.nextInt(currentMaxLength / 4 + 1) + random.nextInt(currentMaxLength / 4 + 1) + random.nextInt(currentMaxLength / 4 + 1) + random.nextInt(currentMaxLength / 4 + 1) + 1;
        if (depth == 0) {
            for (int i = 0; i < length; ++i) {
                currentBranch.add(upward ? Direction.UP : Direction.DOWN);
            }
        } else {
            int i;
            Direction mainDirection = TendrilTreeUtils.getRandomHorizontalDirectionExcept(directionToPrevious.getOpposite());
            int horizontalLength = Math.max(1, (int)((float)length * deviationStrength));
            for (i = 0; i < horizontalLength; ++i) {
                if (random.nextFloat() < 0.8f) {
                    currentBranch.add(mainDirection);
                    continue;
                }
                currentBranch.add(TendrilTreeUtils.getRandomHorizontalDirectionExcept(mainDirection.getOpposite(), mainDirection));
            }
            for (i = horizontalLength; i < length; ++i) {
                currentBranch.add(upward ? Direction.UP : Direction.DOWN);
            }
        }
        List<BlockPos> branchingPos = TendrilTreeUtils.addPosToTree(tree, origin, currentBranch, currentBranchingProbability, random);
        for (BlockPos pos : branchingPos) {
            if (tree.hasNode(pos)) {
                this.recursiveTreeStructure(tree, pos, deviationStrength, depth + 1, maxDepth, currentMaxLength, heightReductionFactor, currentBranchingProbability, random, TendrilTreeUtils.getRandomHorizontalDirectionExcept(directionToPrevious.getOpposite()), upward);
                continue;
            }
            LOGGER.warn("Trying to branch from non-existent node: {}", (Object)pos);
        }
    }
}

