/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.features.custom.sculk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import wardentools.block.BlockRegistry;
import wardentools.block.sculktendril.TendrilTree;
import wardentools.blockentity.SculkTendrilBlockEntity;

public class TendrilTreeUtils {
    public static final int MAX_ELONGATION = 8;

    public static List<BlockPos> addPosToTree(TendrilTree tree, BlockPos origin, List<Direction> directions, float branchingProbability, RandomSource random) {
        if (!tree.hasNode(origin)) {
            return new ArrayList<BlockPos>();
        }
        ArrayList<BlockPos> branchingPos = new ArrayList<BlockPos>();
        BlockPos currentPos = origin;
        float localProbability = branchingProbability;
        boolean hasBranchedLastBlock = false;
        for (Direction direction : directions) {
            if (!tree.hasNode(currentPos) || !tree.canHaveChildren(currentPos)) break;
            BlockPos nextPos = currentPos.relative(direction);
            tree.addNode(nextPos, currentPos);
            if (!tree.hasNode(nextPos)) break;
            if (random.nextFloat() < localProbability && !hasBranchedLastBlock) {
                hasBranchedLastBlock = true;
                branchingPos.add(nextPos);
                localProbability *= 0.9f;
            } else {
                hasBranchedLastBlock = false;
                localProbability *= 1.1f;
            }
            currentPos = nextPos;
        }
        return branchingPos;
    }

    public static Direction getRandomHorizontalDirectionExcept(Direction ... exception) {
        Direction[] directions = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(dir -> exception == null || !List.of(exception).contains(dir)).toArray(Direction[]::new);
        return directions.length > 0 ? directions[(int)(Math.random() * (double)directions.length)] : Direction.NORTH;
    }

    public static void placeBlocksWithoutUpdate(WorldGenLevel level, TendrilTree tree, BlockPos origin) {
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (BlockPos pos : tree.getAllNodes()) {
            if (Math.abs(origin.getX() - pos.getX()) <= 8 && Math.abs(origin.getZ() - pos.getZ()) <= 8) {
                if (level.getBlockState(pos).is(BlockTags.SCULK_REPLACEABLE) || level.getBlockState(pos).isAir()) continue;
                toRemove.add(pos);
                continue;
            }
            toRemove.add(pos);
        }
        for (BlockPos pos : toRemove) {
            tree.recursiveRemove(pos);
        }
        for (BlockPos pos : tree.getAllNodes()) {
            level.setBlock(pos, TendrilTreeUtils.sculkTendril(), 3);
        }
    }

    public static void configureBlockEntities(WorldGenLevel level, TendrilTree tree, BlockPos origin) {
        for (BlockPos pos : tree.getAllNodes()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof SculkTendrilBlockEntity)) continue;
            SculkTendrilBlockEntity tendrilEntity = (SculkTendrilBlockEntity)blockEntity;
            if (pos.equals((Object)origin)) {
                tendrilEntity.setTendrilTreeGraph(tree);
            }
            tendrilEntity.setOrigin(origin);
        }
    }

    private static BlockState sculkTendril() {
        return ((Block)BlockRegistry.SCULK_TENDRIL_BLOCK.get()).defaultBlockState();
    }
}

