/*
 * Decompiled with CFR 0.152.
 */
package wardentools.worldgen.structure;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import wardentools.worldgen.structure.ModStructures;

public class StructureUtils {
    @Nullable
    public static BlockPos findNearestStructure(ServerLevel level, ResourceKey<Structure> structureKey, BlockPos pos) {
        Holder.Reference structureHolder = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getHolderOrThrow(structureKey);
        HolderSet.Direct structureHolderSet = HolderSet.direct((Holder[])new Holder[]{structureHolder});
        Pair result = level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)structureHolderSet, pos, 10000, false);
        return result != null ? (BlockPos)result.getFirst() : null;
    }

    public static boolean isInsideAnyCrystalTemple(WorldGenLevel level, BlockPos origin) {
        StructureManager structureManager = level.getLevel().structureManager();
        Map structures = structureManager.getAllStructuresAt(origin);
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry entry : structures.entrySet()) {
            Holder holder;
            Structure structure = (Structure)entry.getKey();
            Optional holderOpt = registry.getHolder(registry.getId((Object)structure));
            if (holderOpt.isEmpty() || !StructureUtils.isCrystalTempleHolder((Holder<Structure>)(holder = (Holder)holderOpt.get()))) continue;
            AtomicBoolean inside = new AtomicBoolean(false);
            structureManager.fillStartsForStructure(structure, (LongSet)entry.getValue(), start -> {
                if (!start.isValid()) {
                    return;
                }
                if (start.getBoundingBox().isInside((Vec3i)origin) || structureManager.structureHasPieceAt(origin, start)) {
                    inside.set(true);
                }
            });
            if (!inside.get()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCrystalTempleHolder(Holder<Structure> holder) {
        return holder.is(ModStructures.AMETHYST_TEMPLE) || holder.is(ModStructures.RUBY_TEMPLE) || holder.is(ModStructures.CITRINE_TEMPLE) || holder.is(ModStructures.MALACHITE_TEMPLE) || holder.is(ModStructures.PALE_TEMPLE);
    }
}

