/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import wardentools.block.BlockRegistry;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.blockentity.GramophoneBlockEntity;

public class GramophoneBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<GramophoneBlock> CODEC = GramophoneBlock.simpleCodec(GramophoneBlock::new);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    @NotNull
    protected MapCodec<GramophoneBlock> codec() {
        return CODEC;
    }

    public GramophoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0) : Block.box((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)15.5);
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction direction, @NotNull BlockState state1, @NotNull LevelAccessor accessor, @NotNull BlockPos pos, @NotNull BlockPos pos1) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (direction == Direction.UP) || state1.is((Block)this) && state1.getValue(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state1, accessor, pos, pos1);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState stateBelow = level.getBlockState(pos.below());
            if (stateBelow.is((Block)BlockRegistry.GRAMOPHONE.get())) {
                return ((GramophoneBlock)stateBelow.getBlock()).publicUseItemOn(stack, stateBelow, level, pos.below(), player, hand, hitResult);
            }
            return ItemInteractionResult.FAIL;
        }
        return this.publicUseItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    public ItemInteractionResult publicUseItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GramophoneBlockEntity) {
            GramophoneBlockEntity gramophone = (GramophoneBlockEntity)blockEntity;
            if (!gramophone.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ItemStack itemInHand = player.getItemInHand(hand);
            ItemInteractionResult action = GramophoneBlock.tryInsertIntoJukebox(level, pos, itemInHand, player);
            return !action.consumesAction() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : action;
        }
        return ItemInteractionResult.FAIL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            BlockState stateBelow = level.getBlockState(pos.below());
            if (stateBelow.is((Block)BlockRegistry.GRAMOPHONE.get())) {
                return ((GramophoneBlock)stateBelow.getBlock()).publicUseWithoutItem(stateBelow, level, pos.below(), player, hitResult);
            }
            return InteractionResult.FAIL;
        }
        return this.publicUseWithoutItem(state, level, pos, player, hitResult);
    }

    @NotNull
    public InteractionResult publicUseWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GramophoneBlockEntity) {
            GramophoneBlockEntity gramophone = (GramophoneBlockEntity)blockEntity;
            gramophone.popOutTheItem();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static ItemInteractionResult tryInsertIntoJukebox(Level level, BlockPos pos, ItemStack stack, Player player) {
        JukeboxPlayable jukeboxPlayable = (JukeboxPlayable)stack.get(DataComponents.JUKEBOX_PLAYABLE);
        if (jukeboxPlayable == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is((Block)BlockRegistry.GRAMOPHONE.get())) {
            if (!level.isClientSide) {
                ItemStack consumeAndReturn = stack.consumeAndReturn(1, (LivingEntity)player);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof GramophoneBlockEntity) {
                    GramophoneBlockEntity gramophone = (GramophoneBlockEntity)blockEntity;
                    gramophone.setTheItem(consumeAndReturn);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
                }
                player.awardStat(Stats.PLAY_RECORD);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos blockpos = placeContext.getClickedPos();
        Level level = placeContext.getLevel();
        if (blockpos.getY() >= level.getMaxBuildHeight() - 1 || !level.getBlockState(blockpos.above()).canBeReplaced(placeContext)) {
            return null;
        }
        BlockState blockStatePlacement = super.getStateForPlacement(placeContext);
        if (blockStatePlacement != null) {
            return (BlockState)blockStatePlacement.setValue((Property)FACING, (Comparable)placeContext.getHorizontalDirection().getOpposite());
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, @NotNull BlockState state, LivingEntity entity, @NotNull ItemStack stack) {
        BlockPos blockpos = pos.above();
        level.setBlock(blockpos, GramophoneBlock.copyWaterloggedFrom((LevelReader)level, blockpos, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)FACING)))), 3);
    }

    protected boolean canSurvive(BlockState state, @NotNull LevelReader levelReader, @NotNull BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, levelReader, pos);
        }
        BlockState blockstate = levelReader.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, levelReader, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos pos, BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.isWaterAt(pos))) : state;
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (!level.isClientSide) {
            GramophoneBlock.preventDropFromBottomPart(level, pos, state, player);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    protected static void preventDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            level.setBlock(blockpos, blockstate1, 35);
            level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    protected void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState state1, boolean b) {
        if (!state.is(state1.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof GramophoneBlockEntity) {
                GramophoneBlockEntity gramophone = (GramophoneBlockEntity)blockEntity;
                gramophone.popOutTheItem();
            }
            super.onRemove(state, level, pos, state1, b);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HALF}).add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return BlockEntityRegistry.GRAMOPHONE_BLOCK_ENTITY.get().create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (!type.isValid(state)) {
            return null;
        }
        return level.isClientSide() ? (level0, pos0, state0, blockEntity) -> ((GramophoneBlockEntity)blockEntity).clientTick() : (level0, pos0, state0, blockEntity) -> ((GramophoneBlockEntity)blockEntity).tick();
    }
}

