/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.blockentity.LivingSproutBlockEntity;
import wardentools.entity.ModEntities;
import wardentools.entity.custom.ParasyteEntity;
import wardentools.network.payloads.special_effects.LivingSproutBurst;
import wardentools.tags.ModTags;

public class LivingSproutBlock
extends Block
implements EntityBlock {
    public static final int ACTIVE_TICKS = 60;
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.SCULK_SENSOR_PHASE;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public LivingSproutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader levelReader, @NotNull BlockPos pos) {
        return levelReader.getBlockState(pos.below()).is(ModTags.Blocks.SUSTAIN_LIVING_SPROUT) && super.canSurvive(state, levelReader, pos);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos neighbor, boolean b) {
        super.neighborChanged(state, level, pos, block, neighbor, b);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true, null);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new LivingSproutBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{PHASE}).add(new Property[]{TRIGGERED});
    }

    public static SculkSensorPhase getPhase(BlockState state) {
        return (SculkSensorPhase)state.getValue(PHASE);
    }

    public static boolean canActivate(BlockState state) {
        return LivingSproutBlock.getPhase(state) == SculkSensorPhase.INACTIVE;
    }

    public static void activate(@NotNull Level level, @NotNull BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (LivingSproutBlock.canActivate(state)) {
            level.playSound(null, pos, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.8f);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.ACTIVE)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, state.getBlock(), 60);
        }
    }

    public static void deactivate(@NotNull Level level, @NotNull BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (LivingSproutBlock.getPhase(state) == SculkSensorPhase.ACTIVE) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.COOLDOWN)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
            level.scheduleTick(pos, state.getBlock(), 60);
        } else if (LivingSproutBlock.getPhase(state) == SculkSensorPhase.COOLDOWN) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.tick(state, level, pos, random);
        if (LivingSproutBlock.getPhase(state) == SculkSensorPhase.INACTIVE) {
            return;
        }
        if (LivingSproutBlock.getPhase(state) == SculkSensorPhase.COOLDOWN) {
            level.playSound(null, pos, SoundEvents.SCULK_CLICKING_STOP, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.8f);
        }
        LivingSproutBlock.deactivate((Level)level, pos);
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        Player player;
        super.stepOn(level, pos, state, entity);
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            LivingSproutBlock.burst(level, pos);
        } else {
            LivingSproutBlock.activate(level, pos);
        }
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
    }

    public static void burst(Level level, BlockPos pos) {
        if (!level.isClientSide) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(pos).getPos(), (CustomPacketPayload)new LivingSproutBurst(pos.getCenter().toVector3f()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            int parasyteNumber = level.random.nextInt(2, 4);
            for (int i = 0; i < parasyteNumber; ++i) {
                ParasyteEntity parasyte = new ParasyteEntity(ModEntities.PARASYTE.get(), level);
                parasyte.setPos(pos.getCenter());
                parasyte.setHealth(parasyte.getMaxHealth());
                parasyte.setDeltaMovement((level.random.nextDouble() - 0.5) * 0.5, 0.5, (level.random.nextDouble() - 0.5) * 0.5);
                level.addFreshEntity((Entity)parasyte);
            }
        }
    }

    protected void spawnAfterBreak(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull ItemStack stack, boolean silkTouch) {
        super.spawnAfterBreak(state, level, pos, stack, silkTouch);
        LivingSproutBlock.burst((Level)level, pos);
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        return level.isClientSide ? null : (level0, pos, state0, blockEntity) -> ((LivingSproutBlockEntity)blockEntity).tick();
    }
}

