/*
 * Decompiled with CFR 0.152.
 */
package wardentools.block.sculktendril;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.WorldGenLevel;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wardentools.block.sculktendril.TendrilNode;

public class TendrilTree {
    private static final int MAX_LENGTH = 8;
    private BlockPos origin = null;
    private final Map<BlockPos, TendrilNode> nodes = new HashMap<BlockPos, TendrilNode>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public TendrilTree(BlockPos origin) {
        this.addOrigin(origin);
    }

    public TendrilTree(CompoundTag tag) {
        BlockPos position;
        CompoundTag nodeTag;
        String key;
        int i;
        if (tag.contains("origin")) {
            this.origin = TendrilNode.blockPosFromTag(tag.getCompound("origin"));
        }
        boolean stop = false;
        for (i = 1; !stop && i <= 100; ++i) {
            key = TendrilTree.getIndexedKey(i);
            if (tag.contains(key)) {
                nodeTag = tag.getCompound(key);
                position = TendrilNode.blockPosFromTag(nodeTag.getCompound("position"));
                int depth = nodeTag.getInt("depth");
                TendrilNode node = new TendrilNode(position, depth);
                this.nodes.put(position, node);
                continue;
            }
            stop = true;
        }
        stop = false;
        for (i = 1; !stop && i <= 100; ++i) {
            key = TendrilTree.getIndexedKey(i);
            if (tag.contains(key)) {
                nodeTag = tag.getCompound(key);
                position = TendrilNode.blockPosFromTag(nodeTag.getCompound("position"));
                TendrilNode node = this.nodes.get(position);
                if (nodeTag.contains("parent")) {
                    BlockPos parentPos = TendrilNode.blockPosFromTag(nodeTag.getCompound("parent"));
                    TendrilNode parent = this.nodes.get(parentPos);
                    if (parent == null) continue;
                    node.setParent(parent);
                    parent.addChild(node);
                    continue;
                }
                this.addOrigin(position);
                continue;
            }
            stop = true;
        }
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    public List<BlockPos> getAllNodes() {
        return this.nodes.keySet().stream().filter(Objects::nonNull).toList();
    }

    public List<BlockPos> getChildrenOf(BlockPos pos) {
        if (!this.nodes.containsKey(pos)) {
            return List.of();
        }
        TendrilNode node = this.nodes.get(pos);
        return node.getChildren().stream().map(TendrilNode::getPosition).toList();
    }

    @Nullable
    public BlockPos getParentOf(BlockPos pos) {
        if (!this.nodes.containsKey(pos)) {
            return null;
        }
        TendrilNode node = this.nodes.get(pos);
        return node.getParent() == null ? null : node.getParent().getPosition();
    }

    public int getWidth(BlockPos pos) {
        if (!this.nodes.containsKey(pos)) {
            return 0;
        }
        TendrilNode node = this.nodes.get(pos);
        float length = this.getLength(node.getPosition());
        float baseWidth = 8.0f - (float)node.getDepth() + 1.0f;
        return Math.min(Math.max(1, (int)Math.ceil(baseWidth - (8.0f - length) / 2.0f)), 8) * 2;
    }

    public boolean canHaveChildren(BlockPos pos) {
        return this.nodes.get(pos).getDepth() <= 8;
    }

    public void recursiveRemove(BlockPos pos) {
        this.recursiveRemove(pos, 0);
    }

    public void updateAllNodes(WorldGenLevel level) {
        for (Map.Entry<BlockPos, TendrilNode> entry : this.nodes.entrySet()) {
            TendrilNode node = entry.getValue();
            level.scheduleTick(node.getPosition(), level.getBlockState(node.getPosition()).getBlock(), 2);
        }
    }

    public void recursiveRemove(BlockPos pos, int depth) {
        if (!this.nodes.containsKey(pos) || depth > 100) {
            return;
        }
        TendrilNode node = this.nodes.get(pos);
        for (TendrilNode child : node.getChildren()) {
            this.recursiveRemove(child.getPosition(), depth + 1);
        }
        this.nodes.remove(pos);
    }

    public CompoundTag writeTreeToTag() {
        CompoundTag tag = new CompoundTag();
        tag.put("origin", (Tag)(this.origin == null ? new CompoundTag() : TendrilNode.blockPosToTag(this.origin)));
        int i = 0;
        for (Map.Entry<BlockPos, TendrilNode> entry : this.nodes.entrySet()) {
            tag.put(TendrilTree.getIndexedKey(++i), (Tag)entry.getValue().toTag());
        }
        return tag;
    }

    public void addNode(BlockPos pos, BlockPos parentPos) {
        if (this.nodes.containsKey(pos)) {
            return;
        }
        if (this.nodes.containsKey(parentPos)) {
            if (!this.canHaveChildren(parentPos)) {
                return;
            }
            TendrilNode newNode = new TendrilNode(pos, this.nodes.get(parentPos), new TendrilNode[0]);
            this.nodes.put(pos, newNode);
            this.addChildToNode(parentPos, pos);
        } else {
            LOGGER.warn("Tendril node at {} cannot be added because parent node at {} does not exist.", (Object)pos, (Object)parentPos);
        }
    }

    public boolean hasNode(BlockPos pos) {
        return this.nodes.containsKey(pos);
    }

    private void addOrigin(BlockPos origin) {
        this.origin = origin;
        this.nodes.put(origin, new TendrilNode(origin, null, new TendrilNode[0]));
    }

    private void addChildToNode(BlockPos parentPos, BlockPos childPos) {
        if (!this.nodes.containsKey(parentPos) || !this.nodes.containsKey(childPos)) {
            LOGGER.warn("Cannot add child node at {} to parent node at {} because one of them does not exist.", (Object)childPos, (Object)parentPos);
            return;
        }
        this.nodes.get(parentPos).addChild(this.nodes.get(childPos));
    }

    private int getLength(BlockPos pos) {
        if (!this.nodes.containsKey(pos)) {
            return 0;
        }
        TendrilNode node = this.nodes.get(pos);
        return this.getAscendingLength(node.getPosition()) + this.getDescendingLength(node.getPosition()) - 1;
    }

    public int getAscendingLength(BlockPos pos) {
        if (!this.nodes.containsKey(pos)) {
            return 0;
        }
        int length = 1;
        TendrilNode currentNode = this.nodes.get(pos);
        while (currentNode.getParent() != null) {
            ++length;
            currentNode = currentNode.getParent();
        }
        return length;
    }

    public int getDescendingLength(BlockPos pos) {
        return this.getDescendingLength(pos, 0);
    }

    private int getDescendingLength(BlockPos pos, int depth) {
        if (!this.nodes.containsKey(pos) || depth > 100) {
            return 0;
        }
        TendrilNode currentNode = this.nodes.get(pos);
        int maxLength = 0;
        for (TendrilNode child : currentNode.getChildren()) {
            int childLength = this.getDescendingLength(child.getPosition(), depth + 1);
            if (childLength <= maxLength) continue;
            maxLength = childLength;
        }
        return 1 + maxLength;
    }

    private TendrilNode getFirstNexusParent(BlockPos pos) {
        TendrilNode currentNode = this.nodes.get(pos);
        while (currentNode.getParent() != null && currentNode.getParent().getChildren().size() == 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private static String getIndexedKey(int i) {
        return "node_" + i;
    }
}

