/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wardentools.block.BlockRegistry;
import wardentools.block.CrystalInfuserBlock;
import wardentools.blockentity.BlockEntityRegistry;
import wardentools.items.CrystalResonatorItem;
import wardentools.items.ItemRegistry;
import wardentools.misc.Crystal;
import wardentools.sounds.ModSounds;
import wardentools.worldgen.structure.StructureUtils;

public class CrystalInfuserBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (CrystalInfuserBlockEntity.this.level != null && !((CrystalInfuserBlockEntity)CrystalInfuserBlockEntity.this).level.isClientSide) {
                CrystalInfuserBlockEntity.this.sendUpdate();
            }
        }
    };
    private static final int INFUSING_TIME = 120;
    private boolean isInfusing = false;
    public boolean hasEmitedParticles = false;
    private BlockPos cachedStainedGlassCenterPos = null;
    private float nextTempleOrientation = -4.0f;
    private static final int COMPASS_EFFECT_DURATION = 2400;
    private int compassEffectTick = 0;

    protected CrystalInfuserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public CrystalInfuserBlockEntity(BlockPos pos, BlockState state) {
        this(BlockEntityRegistry.CRYSTAL_INFUSER_BLOCK_ENTITY.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(provider));
        tag.putBoolean("is_infusing", this.isInfusing);
        tag.putFloat("next_temple_orientation", this.nextTempleOrientation);
        tag.putInt("compass_effect_tick", this.compassEffectTick);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("inventory", 10)) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            }
            this.inventory.deserializeNBT(provider, tag.getCompound("inventory"));
        }
        if (tag.contains("is_infusing", 1)) {
            this.isInfusing = tag.getBoolean("is_infusing");
        }
        if (tag.contains("next_temple_orientation", 5)) {
            this.nextTempleOrientation = tag.getFloat("next_temple_orientation");
        }
        if (tag.contains("compass_effect_tick", 3)) {
            this.compassEffectTick = tag.getInt("compass_effect_tick");
        }
    }

    public void triggerCompassEffect() {
        this.compassEffectTick = 2400;
    }

    public void tick() {
        if (this.compassEffectTick > 0) {
            --this.compassEffectTick;
        }
    }

    public void clientTick() {
        BlockState state = this.getBlockState();
        if (this.level == null || !state.is((Block)BlockRegistry.CRYSTAL_INFUSER.get())) {
            return;
        }
        if (this.isInfusing()) {
            CrystalInfuserBlock.particleShine(state, this.worldPosition, this.level, this.level.random);
            if (!this.hasEmitedParticles) {
                this.level.playLocalSound(this.worldPosition, ModSounds.INFUSER_CHARGING.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
                CrystalInfuserBlock.particleGlyph(state, this.worldPosition, this.level);
                this.hasEmitedParticles = true;
            }
        } else {
            this.hasEmitedParticles = false;
        }
        if (this.compassEffectTick > 0) {
            --this.compassEffectTick;
            CrystalInfuserBlock.giantCompassParticle(state, this.level, this);
            CrystalInfuserBlock.ambientParticles(state, this.worldPosition, this.level);
        }
    }

    public boolean setItemInAvailableSlot(@NotNull ItemStack stack) {
        if (this.isInfusing) {
            return false;
        }
        if (Crystal.isCrystalItem(stack.getItem())) {
            for (int i = 0; i < this.inventory.getSlots() - 1; ++i) {
                if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
                ItemStack copy = stack.copy();
                copy.setCount(1);
                this.inventory.setStackInSlot(i, copy);
                stack.shrink(1);
                this.beginInfuseIfAble();
                return true;
            }
        } else if (stack.is((Item)ItemRegistry.CRYSTAL_RESONATOR.get()) && this.inventory.getStackInSlot(4).isEmpty()) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.inventory.setStackInSlot(4, copy);
            stack.shrink(1);
            this.beginInfuseIfAble();
            return true;
        }
        return false;
    }

    public ItemStack removeItemInOrder() {
        if (this.isInfusing) {
            return ItemStack.EMPTY;
        }
        for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            ItemStack stack = this.inventory.getStackInSlot(i).copy();
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void beginInfuseIfAble() {
        if (this.isInfusing) {
            return;
        }
        ItemStack resonator = this.inventory.getStackInSlot(4);
        if (resonator.isEmpty() || !resonator.is((Item)ItemRegistry.CRYSTAL_RESONATOR.get())) {
            return;
        }
        ItemStack infusingCrystal = this.inventory.getStackInSlot(0);
        if (infusingCrystal.isEmpty()) {
            return;
        }
        for (int i = 1; i < 4; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.isEmpty()) {
                return;
            }
            if (slotStack.is(infusingCrystal.getItem())) continue;
            return;
        }
        if (this.getBlockState().getValue(CrystalInfuserBlock.CRYSTAL) != Crystal.fromItem(infusingCrystal.getItem())) {
            return;
        }
        if (this.level == null) {
            return;
        }
        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 120);
        this.isInfusing = true;
        this.getNextTempleOrientation();
    }

    public void completeInfuse() {
        if (!this.isInfusing) {
            return;
        }
        ItemStack resonator = this.inventory.getStackInSlot(4);
        if (resonator.isEmpty() || !resonator.is((Item)ItemRegistry.CRYSTAL_RESONATOR.get())) {
            this.isInfusing = false;
            return;
        }
        ItemStack infusingCrystal = this.inventory.getStackInSlot(0);
        if (infusingCrystal.isEmpty()) {
            this.isInfusing = false;
            return;
        }
        Crystal crystal = Crystal.fromItem(infusingCrystal.getItem());
        CrystalResonatorItem.setCrystal(resonator, crystal);
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.inventory.setStackInSlot(4, resonator);
        this.isInfusing = false;
        this.triggerCompassEffect();
        if (this.level != null) {
            this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
        }
        this.sendUpdate();
    }

    public BlockPos getStainedGlassCenterPos() {
        if (this.cachedStainedGlassCenterPos == null) {
            this.cachedStainedGlassCenterPos = this.getBlockState().hasProperty((Property)CrystalInfuserBlock.FACING) ? this.worldPosition.above(9).relative((Direction)this.getBlockState().getValue((Property)CrystalInfuserBlock.FACING), 4) : this.worldPosition.above(9);
        }
        return this.cachedStainedGlassCenterPos;
    }

    public float getNextTempleOrientation() {
        if (this.level == null) {
            return 0.0f;
        }
        if (this.nextTempleOrientation == -4.0f) {
            ResourceKey<Structure> templeKey;
            BlockPos nexTemplePos;
            if (!this.level.isClientSide && this.getBlockState().hasProperty(CrystalInfuserBlock.CRYSTAL) && (nexTemplePos = StructureUtils.findNearestStructure((ServerLevel)this.level, templeKey = ((Crystal)((Object)this.getBlockState().getValue(CrystalInfuserBlock.CRYSTAL))).getTempleKey(), this.worldPosition)) != null) {
                Vec3 toTemple = Vec3.atCenterOf((Vec3i)nexTemplePos).subtract(Vec3.atCenterOf((Vec3i)this.worldPosition));
                this.nextTempleOrientation = (float)Math.atan2(toTemple.z, toTemple.x);
            }
            this.sendUpdate();
        }
        return this.nextTempleOrientation;
    }

    public boolean isInfusing() {
        return this.isInfusing;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void sendUpdate() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }
}

