/*
 * Decompiled with CFR 0.152.
 */
package wardentools.blockentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.blockentity.CrystalInfuserBlockEntity;
import wardentools.items.ItemRegistry;

@OnlyIn(value=Dist.CLIENT)
public class CrystalInfuserRenderer
implements BlockEntityRenderer<CrystalInfuserBlockEntity> {
    private static final float scale = 0.35f;
    private final BlockEntityRendererProvider.Context context;

    public CrystalInfuserRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull CrystalInfuserBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        for (int i = 0; i < 5; ++i) {
            Vec3 rotation;
            Vec3 position;
            if (blockEntity.getInventory().getStackInSlot(i).isEmpty()) continue;
            ItemStack itemStack = blockEntity.getInventory().getStackInSlot(i);
            float rotSup = itemStack.is(Items.AMETHYST_SHARD) ? -20.25f : 0.0f;
            rotSup += itemStack.is(Items.ECHO_SHARD) ? 45.0f : 0.0f;
            rotSup += itemStack.is((Item)ItemRegistry.PALE_SHARD.get()) ? 45.0f : 0.0f;
            if (i == 4) {
                float resonatorRot = blockEntity.getLevel() != null ? ((float)blockEntity.getLevel().getGameTime() + partialTick) * 0.8f : 0.0f;
                position = new Vec3(8.0, 16.0, 8.0);
                rotation = new Vec3(0.0, (double)resonatorRot, 0.0);
            } else if (i == 1) {
                position = new Vec3(5.5, (double)10.35f, 5.5);
                rotation = new Vec3(90.0, (double)(-135.0f + rotSup), 0.0);
            } else if (i == 2) {
                position = new Vec3(10.5, (double)10.35f, 5.5);
                rotation = new Vec3(90.0, (double)(135.0f + rotSup), 0.0);
            } else if (i == 3) {
                position = new Vec3(5.5, (double)10.35f, 10.5);
                rotation = new Vec3(90.0, (double)(-45.0f + rotSup), 0.0);
            } else {
                position = new Vec3(10.5, (double)10.35f, 10.5);
                rotation = new Vec3(90.0, (double)(45.0f + rotSup), 0.0);
            }
            this.renderItemAtPosition(itemStack, poseStack, buffer, blockEntity.getLevel(), position, rotation, packedLight, packedOverlay);
        }
    }

    public void renderItemAtPosition(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, Level level, Vec3 position, Vec3 rotation, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(position.x / 16.0, position.y / 16.0, position.z / 16.0);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)rotation.y));
        poseStack.mulPose(Axis.XP.rotationDegrees((float)rotation.x));
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation.z));
        poseStack.scale(0.35f, 0.35f, 0.35f);
        this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, level, 0);
        poseStack.popPose();
    }
}

