/*
 * Decompiled with CFR 0.152.
 */
package wardentools.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import wardentools.entity.animations.TemperAnimation;
import wardentools.entity.custom.TemperEntity;

@OnlyIn(value=Dist.CLIENT)
public class Temper
extends HierarchicalModel<TemperEntity>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"wardentools", (String)"temper"), "main");
    private static final float MAX_FLAP_ANGLE = 0.47123888f;
    private boolean wingOnAscending = true;
    private float wingAngle = 0.0f;
    private final ModelPart FULL;
    private final ModelPart HEAD;
    private final ModelPart BODY;
    private final ModelPart TORSO;
    private final ModelPart WING_R;
    private final ModelPart ARM_L;
    private final ModelPart ARM_R;
    private final ModelPart WING_L;

    public Temper(ModelPart root) {
        this.FULL = root.getChild("FULL");
        this.HEAD = this.FULL.getChild("HEAD");
        this.BODY = this.FULL.getChild("BODY");
        this.TORSO = this.BODY.getChild("TORSO");
        this.WING_R = this.BODY.getChild("WING_R");
        this.ARM_L = this.BODY.getChild("ARM_L");
        this.ARM_R = this.BODY.getChild("ARM_R");
        this.WING_L = this.BODY.getChild("WING_L");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition FULL = partdefinition.addOrReplaceChild("FULL", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)27.0f, (float)-1.0f));
        PartDefinition HEAD = FULL.addOrReplaceChild("HEAD", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-8.0f, (float)1.0f));
        PartDefinition BODY = FULL.addOrReplaceChild("BODY", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition TORSO = BODY.addOrReplaceChild("TORSO", CubeListBuilder.create().texOffs(2, 18).addBox(-1.0f, 2.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-8.0f, (float)1.0f));
        PartDefinition WING_R = BODY.addOrReplaceChild("WING_R", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.5f, (float)2.0f));
        PartDefinition wing_r_r1 = WING_R.addOrReplaceChild("wing_r_r1", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, -0.5f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.4363f, (float)0.0f));
        PartDefinition ARM_L = BODY.addOrReplaceChild("ARM_L", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-7.75f, (float)1.0f));
        PartDefinition arm_l_r1 = ARM_L.addOrReplaceChild("arm_l_r1", CubeListBuilder.create().texOffs(23, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition ARM_R = BODY.addOrReplaceChild("ARM_R", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-7.75f, (float)1.0f));
        PartDefinition arm_r_r1 = ARM_R.addOrReplaceChild("arm_r_r1", CubeListBuilder.create().texOffs(23, 6).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition WING_L = BODY.addOrReplaceChild("WING_L", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)-6.5f, (float)2.0f));
        PartDefinition wing_l_r1 = WING_L.addOrReplaceChild("wing_l_r1", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, -0.5f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.4363f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int i) {
        this.FULL.render(poseStack, vertexConsumer, packedLight, packedOverlay, i);
    }

    @NotNull
    public ModelPart root() {
        return this.FULL;
    }

    public void translateToHand(@NotNull HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.09375f, 1.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotation(this.ARM_L.xRot));
        poseStack.mulPose(Axis.ZP.rotation(-0.2617994f + this.ARM_L.zRot));
        poseStack.translate(0.0f, 0.15625f, 0.0f);
        poseStack.scale(0.4f, 0.4f, 0.4f);
    }

    public void setupAnim(TemperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!entity.onGround()) {
            this.flap(2.0f);
        }
        this.animate(entity.attackAnimationState, TemperAnimation.attack, ageInTicks);
        this.HEAD.xRot += headPitch * ((float)Math.PI / 180);
        this.HEAD.yRot += netHeadYaw * ((float)Math.PI / 180);
    }

    private void flap(float flapSpeed) {
        float newAngle = this.wingAngle + (this.wingOnAscending ? flapSpeed : -flapSpeed) * ((float)Math.PI / 180);
        if (newAngle > 0.47123888f) {
            this.wingOnAscending = false;
        } else if (newAngle < -0.47123888f) {
            this.wingOnAscending = true;
        }
        this.wingAngle = newAngle;
        this.WING_L.yRot += this.wingAngle;
        this.WING_R.yRot -= this.wingAngle;
    }
}

