/*
 * Decompiled with CFR 0.152.
 */
package wardentools.events.gameevents;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import wardentools.entity.custom.ContagionIncarnationEntity;
import wardentools.entity.custom.DeepLurkerEntity;

@EventBusSubscriber(modid="wardentools")
public class WardenTargetFilter {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingVisibilityEvent event) {
        Warden warden;
        LivingEntity target;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Warden && ((target = (warden = (Warden)entity).getTarget()) instanceof DeepLurkerEntity || target instanceof ContagionIncarnationEntity)) {
            warden.setTarget(null);
            warden.setAggressive(false);
            warden.setLastHurtByMob(null);
            WardenTargetFilter.makeWardenBurrow(warden);
        }
    }

    private static void makeWardenBurrow(Warden warden) {
        Level level = warden.level();
        if (!level.isClientSide) {
            warden.getBrain().stopAll((ServerLevel)level, (LivingEntity)warden);
            warden.getBrain().clearMemories();
        }
    }
}

