/*
 * Decompiled with CFR 0.152.
 */
package wardentools.items.utils;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CrystalResonatorPropertyFunction
implements ClampedItemPropertyFunction {
    public static final int ROTATION_NONE = -1;
    private final CompassWobble wobble = new CompassWobble();
    @Nullable
    public final CompassTarget compassTarget;

    public CrystalResonatorPropertyFunction(@Nullable CompassTarget compassTarget) {
        this.compassTarget = compassTarget;
    }

    public float call(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int tick) {
        return this.unclampedCall(stack, level, entity, tick);
    }

    public float unclampedCall(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int tick) {
        LivingEntity stackEntity;
        Object object = stackEntity = entity != null ? entity : stack.getEntityRepresentation();
        if (stackEntity == null) {
            return -1.0f;
        }
        return (level = this.tryFetchLevelIfMissing((Entity)stackEntity, level)) == null ? -1.0f : this.getCompassRotation(stack, level, (Entity)stackEntity);
    }

    private float getCompassRotation(ItemStack stack, ClientLevel level, Entity entity) {
        if (this.compassTarget == null) {
            return -1.0f;
        }
        GlobalPos pos = this.compassTarget.getPos(level, stack, entity);
        long time = level.getGameTime();
        return !this.isValidCompassTargetPos(entity, pos) ? -1.0f : this.getRotationTowardsCompassTarget(entity, time, pos.pos());
    }

    private float getRotationTowardsCompassTarget(Entity entity, long partialTick, BlockPos pos) {
        Player player;
        double angleFromEntityToPos = this.getAngleFromEntityToPos(entity, pos);
        double visualRotationY = this.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobble.shouldUpdate(partialTick)) {
                this.wobble.update(partialTick, 0.5 - (visualRotationY - 0.25));
            }
            double finalRotation = angleFromEntityToPos + this.wobble.rotation;
            return Mth.positiveModulo((float)((float)finalRotation), (float)1.0f);
        }
        double finalRotation = 0.5 - (visualRotationY - 0.25 - angleFromEntityToPos);
        return Mth.positiveModulo((float)((float)finalRotation), (float)1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity entity, @Nullable ClientLevel level) {
        return level == null && entity.level() instanceof ClientLevel ? (ClientLevel)entity.level() : level;
    }

    private boolean isValidCompassTargetPos(Entity entity, @Nullable GlobalPos pos) {
        return pos != null && pos.pos() != BlockPos.ZERO && pos.dimension() == entity.level().dimension() && !(pos.pos().distToCenterSqr((Position)entity.position()) < (double)1.0E-5f);
    }

    private double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(center.z() - entity.getZ(), center.x() - entity.getX()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((double)(entity.getVisualRotationYInDegrees() / 360.0f), (double)1.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long partialTick) {
            return this.lastUpdateTick != partialTick;
        }

        void update(long partialTick, double prevRot) {
            this.lastUpdateTick = partialTick;
            double deltaRot = prevRot - this.rotation;
            deltaRot = Mth.positiveModulo((double)(deltaRot + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += deltaRot * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public GlobalPos getPos(ClientLevel var1, ItemStack var2, Entity var3);
    }
}

